/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.policy.LiteralPolicyExpression;
import org.nhindirect.policy.LiteralPolicyExpressionFactory;
import org.nhindirect.policy.OperationPolicyExpression;
import org.nhindirect.policy.OperationPolicyExpressionFactory;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyExpressionType;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyParseException;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.impl.XMLLexiconPolicyParser;
import org.nhindirect.policy.x509.ExtendedKeyUsageExtensionField;
import org.nhindirect.policy.x509.ExtendedKeyUsageIdentifier;
import org.nhindirect.policy.x509.KeyUsageBit;
import org.nhindirect.policy.x509.KeyUsageExtensionField;

public class XMLLexiconPolicyParser_serializeTest {
    @Test
    public void testSerialize_simpleExpression_validateExpression() throws Exception {
        XMLLexiconPolicyParser parser = new XMLLexiconPolicyParser();
        LiteralPolicyExpression expr = LiteralPolicyExpressionFactory.getInstance((Object)KeyUsageBit.DATA_ENCIPHERMENT.getUsageBit());
        KeyUsageExtensionField extensionField = new KeyUsageExtensionField(true);
        Vector<Object> operands = new Vector<Object>();
        operands.add(expr);
        operands.add(extensionField);
        OperationPolicyExpression oper = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.EQUALS, operands);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        parser.serialize((PolicyExpression)oper, (OutputStream)outStream);
        String XML = new String(outStream.toByteArray());
        System.out.println(XML);
    }

    @Test
    public void testSerialize_complexExpression_validateExpression() throws Exception {
        XMLLexiconPolicyParser parser = new XMLLexiconPolicyParser();
        Integer keyUsage = 32;
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)keyUsage);
        LiteralPolicyExpression expr1 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op1);
        KeyUsageExtensionField expr2 = new KeyUsageExtensionField(true);
        Vector<Object> operands1 = new Vector<Object>();
        operands1.add(expr1);
        operands1.add(expr2);
        OperationPolicyExpression oper1 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.BITWISE_AND, operands1);
        PolicyValue op3 = PolicyValueFactory.getInstance((Object)0);
        LiteralPolicyExpression expr3 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op3);
        Vector<Object> operands2 = new Vector<Object>();
        operands2.add(oper1);
        operands2.add(expr3);
        OperationPolicyExpression oper2 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.GREATER, operands2);
        ExtendedKeyUsageExtensionField expr4 = new ExtendedKeyUsageExtensionField(true);
        PolicyValue op5 = PolicyValueFactory.getInstance((Object)ExtendedKeyUsageIdentifier.ID_KP_EMAIL_PROTECTION.getId());
        LiteralPolicyExpression expr5 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op5);
        Vector<Object> operands3 = new Vector<Object>();
        operands3.add(expr4);
        operands3.add(expr5);
        OperationPolicyExpression oper3 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.CONTAINS, operands3);
        Vector<OperationPolicyExpression> operands4 = new Vector<OperationPolicyExpression>();
        operands4.add(oper2);
        operands4.add(oper3);
        OperationPolicyExpression oper4 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.LOGICAL_AND, operands4);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        parser.serialize((PolicyExpression)oper4, (OutputStream)outStream);
        Assertions.assertTrue((outStream.size() > 0 ? 1 : 0) != 0);
        String XML = new String(outStream.toByteArray());
        System.out.println(XML);
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        PolicyExpression deserExpression = parser.parse((InputStream)inStream);
        Assertions.assertNotNull((Object)deserExpression);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)deserExpression.getExpressionType());
    }

    @Test
    public void testSerialize_nullExpression_assertExecption() throws Exception {
        boolean exceptionOccured = false;
        XMLLexiconPolicyParser parser = new XMLLexiconPolicyParser();
        try {
            parser.serialize(null, null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testSerialize_nullStream_assertExecption() throws Exception {
        boolean exceptionOccured = false;
        XMLLexiconPolicyParser parser = new XMLLexiconPolicyParser();
        try {
            parser.serialize((PolicyExpression)Mockito.mock(PolicyExpression.class), null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testDeserialize_nullStream_assertExecption() throws Exception {
        boolean exceptionOccured = false;
        XMLLexiconPolicyParser parser = new XMLLexiconPolicyParser();
        try {
            parser.deserialize(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testDeserializeo_invalidXML_assertExecption() throws Exception {
        boolean exceptionOccured = false;
        XMLLexiconPolicyParser parser = new XMLLexiconPolicyParser();
        try {
            parser.deserialize((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2}));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

