/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl.machine;

import java.security.cert.X509Certificate;
import java.util.Vector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.LiteralPolicyExpression;
import org.nhindirect.policy.LiteralPolicyExpressionFactory;
import org.nhindirect.policy.OperationPolicyExpression;
import org.nhindirect.policy.OperationPolicyExpressionFactory;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.impl.machine.StackMachine;
import org.nhindirect.policy.impl.machine.StackMachineCompiler;
import org.nhindirect.policy.impl.machine.StackMachineEntry;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.ExtendedKeyUsageExtensionField;
import org.nhindirect.policy.x509.ExtendedKeyUsageIdentifier;
import org.nhindirect.policy.x509.KeyUsageExtensionField;

public class StackMachineCompiler_compileTest {
    @Test
    public void testCompile_simpleUnaryLiteralOperation_assertEntriesAndEvaluation() throws Exception {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)true);
        LiteralPolicyExpression expr = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op1);
        Vector<LiteralPolicyExpression> operands = new Vector<LiteralPolicyExpression>();
        operands.add(expr);
        OperationPolicyExpression oper = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.LOGICAL_NOT, operands);
        StackMachineCompiler compiler = new StackMachineCompiler();
        Vector entries = compiler.compile(null, (PolicyExpression)oper);
        Assertions.assertEquals((int)2, (int)entries.size());
        Assertions.assertEquals((Object)op1, (Object)((StackMachineEntry)entries.get(0)).getValue());
        Assertions.assertEquals((Object)PolicyOperator.LOGICAL_NOT, (Object)((StackMachineEntry)entries.get(1)).getOperator());
        StackMachine machine = new StackMachine();
        Boolean evalVal = machine.evaluate(entries);
        Assertions.assertFalse((boolean)evalVal);
    }

    @Test
    public void testCompile_simpleBinaryLiteralOperation_assertEntriesAndEvaluation() throws Exception {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)1);
        PolicyValue op2 = PolicyValueFactory.getInstance((Object)1);
        LiteralPolicyExpression expr1 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op1);
        LiteralPolicyExpression expr2 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op2);
        Vector<LiteralPolicyExpression> operands = new Vector<LiteralPolicyExpression>();
        operands.add(expr1);
        operands.add(expr2);
        OperationPolicyExpression oper = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.EQUALS, operands);
        StackMachineCompiler compiler = new StackMachineCompiler();
        Vector entries = compiler.compile(null, (PolicyExpression)oper);
        Assertions.assertEquals((int)3, (int)entries.size());
        Assertions.assertEquals((Object)op1, (Object)((StackMachineEntry)entries.get(0)).getValue());
        Assertions.assertEquals((Object)op2, (Object)((StackMachineEntry)entries.get(1)).getValue());
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)((StackMachineEntry)entries.get(2)).getOperator());
        StackMachine machine = new StackMachine();
        Boolean evalVal = machine.evaluate(entries);
        Assertions.assertTrue((boolean)evalVal);
    }

    @Test
    public void testCompile_simpleBinaryLiteralAndExpressionOperation_assertEntriesAndEvaluation() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        Integer keyUsage = 224;
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)keyUsage);
        LiteralPolicyExpression expr1 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op1);
        KeyUsageExtensionField expr2 = new KeyUsageExtensionField(true);
        Vector<Object> operands = new Vector<Object>();
        operands.add(expr1);
        operands.add(expr2);
        OperationPolicyExpression oper = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.EQUALS, operands);
        StackMachineCompiler compiler = new StackMachineCompiler();
        Vector entries = compiler.compile(cert, (PolicyExpression)oper);
        Assertions.assertEquals((int)3, (int)entries.size());
        Assertions.assertEquals((Object)op1, (Object)((StackMachineEntry)entries.get(0)).getValue());
        Assertions.assertEquals((Object)keyUsage, (Object)((StackMachineEntry)entries.get(1)).getValue().getPolicyValue());
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)((StackMachineEntry)entries.get(2)).getOperator());
        StackMachine machine = new StackMachine();
        Boolean evalVal = machine.evaluate(entries);
        Assertions.assertTrue((boolean)evalVal);
    }

    @Test
    public void testCompile_multipleEmbeddedOperations_keyUsage_assertEntriesAndEvaluation() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        Integer keyUsage = 64;
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)keyUsage);
        LiteralPolicyExpression expr1 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op1);
        KeyUsageExtensionField expr2 = new KeyUsageExtensionField(true);
        Vector<Object> operands1 = new Vector<Object>();
        operands1.add(expr1);
        operands1.add(expr2);
        OperationPolicyExpression oper1 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.BITWISE_AND, operands1);
        PolicyValue op3 = PolicyValueFactory.getInstance((Object)0);
        LiteralPolicyExpression expr3 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op3);
        Vector<Object> operands2 = new Vector<Object>();
        operands2.add(oper1);
        operands2.add(expr3);
        OperationPolicyExpression oper2 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.GREATER, operands2);
        StackMachineCompiler compiler = new StackMachineCompiler();
        Vector entries = compiler.compile(cert, (PolicyExpression)oper2);
        Assertions.assertEquals((int)5, (int)entries.size());
        Assertions.assertEquals((Object)op1, (Object)((StackMachineEntry)entries.get(0)).getValue());
        Assertions.assertEquals((Object)expr2.getPolicyValue().getPolicyValue(), (Object)((StackMachineEntry)entries.get(1)).getValue().getPolicyValue());
        Assertions.assertEquals((Object)PolicyOperator.BITWISE_AND, (Object)((StackMachineEntry)entries.get(2)).getOperator());
        Assertions.assertEquals((Object)op3, (Object)((StackMachineEntry)entries.get(3)).getValue());
        Assertions.assertEquals((Object)PolicyOperator.GREATER, (Object)((StackMachineEntry)entries.get(4)).getOperator());
        StackMachine machine = new StackMachine();
        Boolean evalVal = machine.evaluate(entries);
        Assertions.assertTrue((boolean)evalVal);
    }

    @Test
    public void testCompile_multipleEmbeddedOperations_extendedKeyUsage_keyUsage_assertEntriesAndEvaluation() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("mshost.der");
        Integer keyUsage = 64;
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)keyUsage);
        LiteralPolicyExpression expr1 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op1);
        KeyUsageExtensionField expr2 = new KeyUsageExtensionField(true);
        Vector<Object> operands1 = new Vector<Object>();
        operands1.add(expr1);
        operands1.add(expr2);
        OperationPolicyExpression oper1 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.BITWISE_AND, operands1);
        PolicyValue op3 = PolicyValueFactory.getInstance((Object)0);
        LiteralPolicyExpression expr3 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op3);
        Vector<Object> operands2 = new Vector<Object>();
        operands2.add(oper1);
        operands2.add(expr3);
        OperationPolicyExpression oper2 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.GREATER, operands2);
        StackMachineCompiler compiler = new StackMachineCompiler();
        ExtendedKeyUsageExtensionField expr4 = new ExtendedKeyUsageExtensionField(true);
        PolicyValue op5 = PolicyValueFactory.getInstance((Object)ExtendedKeyUsageIdentifier.ID_KP_EMAIL_PROTECTION.getId());
        LiteralPolicyExpression expr5 = LiteralPolicyExpressionFactory.getInstance((PolicyValue)op5);
        Vector<Object> operands3 = new Vector<Object>();
        operands3.add(expr4);
        operands3.add(expr5);
        OperationPolicyExpression oper3 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.CONTAINS, operands3);
        Vector<OperationPolicyExpression> operands4 = new Vector<OperationPolicyExpression>();
        operands4.add(oper2);
        operands4.add(oper3);
        OperationPolicyExpression oper4 = OperationPolicyExpressionFactory.getInstance((PolicyOperator)PolicyOperator.LOGICAL_AND, operands4);
        Vector entries = compiler.compile(cert, (PolicyExpression)oper4);
        Assertions.assertEquals((int)9, (int)entries.size());
        Assertions.assertEquals((Object)op1, (Object)((StackMachineEntry)entries.get(0)).getValue());
        Assertions.assertEquals((Object)expr2.getPolicyValue().getPolicyValue(), (Object)((StackMachineEntry)entries.get(1)).getValue().getPolicyValue());
        Assertions.assertEquals((Object)PolicyOperator.BITWISE_AND, (Object)((StackMachineEntry)entries.get(2)).getOperator());
        Assertions.assertEquals((Object)op3, (Object)((StackMachineEntry)entries.get(3)).getValue());
        Assertions.assertEquals((Object)PolicyOperator.GREATER, (Object)((StackMachineEntry)entries.get(4)).getOperator());
        Assertions.assertEquals((Object)expr4.getPolicyValue(), (Object)((StackMachineEntry)entries.get(5)).getValue());
        Assertions.assertEquals((Object)op5, (Object)((StackMachineEntry)entries.get(6)).getValue());
        Assertions.assertEquals((Object)PolicyOperator.CONTAINS, (Object)((StackMachineEntry)entries.get(7)).getOperator());
        Assertions.assertEquals((Object)PolicyOperator.LOGICAL_AND, (Object)((StackMachineEntry)entries.get(8)).getOperator());
        StackMachine machine = new StackMachine();
        Boolean evalVal = machine.evaluate(entries);
        Assertions.assertTrue((boolean)evalVal);
    }
}

