/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl.machine;

import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.impl.machine.StackMachineCompiler;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.KeyUsageExtensionField;

public class StackMachine_getCompilationReportTest {
    @Test
    public void testGetCompilationReportTest_noReport_assertEmptyCollection() {
        StackMachineCompiler machine = new StackMachineCompiler();
        Assertions.assertTrue((boolean)machine.getCompilationReport().isEmpty());
    }

    @Test
    public void testGetCompilationReportTest_missingRequiredField_reportModeOff_assertEmptyCollection() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("umesh.der");
        KeyUsageExtensionField keyExtendExp = new KeyUsageExtensionField(true);
        StackMachineCompiler machine = new StackMachineCompiler();
        machine.setReportModeEnabled(false);
        Assertions.assertFalse((boolean)machine.isReportModeEnabled());
        boolean exceptionOccured = false;
        try {
            machine.compile(cert, (PolicyExpression)keyExtendExp);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        Assertions.assertTrue((boolean)machine.getCompilationReport().isEmpty());
    }

    @Test
    public void testGetCompilationReportTest_missingRequiredField_reportModeOn_assertNonEmptyCollection() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("umesh.der");
        KeyUsageExtensionField keyExtendExp = new KeyUsageExtensionField(true);
        StackMachineCompiler machine = new StackMachineCompiler();
        machine.setReportModeEnabled(true);
        Assertions.assertTrue((boolean)machine.isReportModeEnabled());
        machine.compile(cert, (PolicyExpression)keyExtendExp);
        Assertions.assertEquals((int)1, (int)machine.getCompilationReport().size());
    }

    @Test
    public void testGetCompilationReportTest_mulipleCompilations_reportModeOn_assertCorrectReportSize() throws Exception {
        X509Certificate cert1 = TestUtils.loadCertificate("umesh.der");
        X509Certificate cert2 = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        KeyUsageExtensionField keyExtendExp = new KeyUsageExtensionField(true);
        StackMachineCompiler machine = new StackMachineCompiler();
        machine.setReportModeEnabled(true);
        Assertions.assertTrue((boolean)machine.isReportModeEnabled());
        machine.compile(cert1, (PolicyExpression)keyExtendExp);
        Assertions.assertEquals((int)1, (int)machine.getCompilationReport().size());
        keyExtendExp = new KeyUsageExtensionField(true);
        machine.compile(cert2, (PolicyExpression)keyExtendExp);
        Assertions.assertTrue((boolean)machine.getCompilationReport().isEmpty());
        keyExtendExp = new KeyUsageExtensionField(true);
        machine.compile(cert1, (PolicyExpression)keyExtendExp);
        Assertions.assertEquals((int)1, (int)machine.getCompilationReport().size());
    }

    @Test
    public void testGetCompilationReportTest_switchModes_assertCorrectReportSize() throws Exception {
        X509Certificate cert1 = TestUtils.loadCertificate("umesh.der");
        KeyUsageExtensionField keyExtendExp = new KeyUsageExtensionField(true);
        StackMachineCompiler machine = new StackMachineCompiler();
        machine.setReportModeEnabled(true);
        Assertions.assertTrue((boolean)machine.isReportModeEnabled());
        machine.compile(cert1, (PolicyExpression)keyExtendExp);
        Assertions.assertEquals((int)1, (int)machine.getCompilationReport().size());
        keyExtendExp = new KeyUsageExtensionField(true);
        machine.setReportModeEnabled(false);
        Assertions.assertFalse((boolean)machine.isReportModeEnabled());
        boolean exceptionOccured = false;
        try {
            machine.compile(cert1, (PolicyExpression)keyExtendExp);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        Assertions.assertTrue((boolean)machine.getCompilationReport().isEmpty());
    }
}

