/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.BasicContraintsExtensionField;
import org.nhindirect.policy.x509.ExtendedKeyUsageExtensionField;
import org.nhindirect.policy.x509.ExtensionIdentifier;
import org.nhindirect.policy.x509.SubjectKeyIdentifierExtensionField;

public class AbstractExtensionField_isCriticalTest {
    @Test
    public void testIsCritical_extensionNotPresent_assertFalse() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("umesh.der");
        Assertions.assertFalse((boolean)cert.getCriticalExtensionOIDs().contains(ExtensionIdentifier.EXTENDED_KEY_USAGE.getId()));
        ExtendedKeyUsageExtensionField field = new ExtendedKeyUsageExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertFalse((boolean)field.isCritical());
    }

    @Test
    public void testIsCritical_extensionPresent_notCritical_assertFalse() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("umesh.der");
        Assertions.assertFalse((boolean)cert.getCriticalExtensionOIDs().contains(ExtensionIdentifier.SUBJECT_KEY_IDENTIFIER.getId()));
        SubjectKeyIdentifierExtensionField field = new SubjectKeyIdentifierExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertFalse((boolean)field.isCritical());
    }

    @Test
    public void testIsCritical_extensionPresent_isCritical_assertTrue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("CernerDirect DevCert Provider CA.der");
        Assertions.assertTrue((boolean)cert.getCriticalExtensionOIDs().contains(ExtensionIdentifier.BASIC_CONSTRAINTS.getId()));
        BasicContraintsExtensionField field = new BasicContraintsExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertTrue((boolean)field.isCritical());
    }

    @Test
    public void testIsCritical_certMission_assertException() throws Exception {
        BasicContraintsExtensionField field = new BasicContraintsExtensionField(false);
        boolean exceptionOccured = false;
        try {
            field.isCritical();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

