/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.AuthorityKeyIdentifierKeyIdExtensionField;

public class AuthorityKeyIdentifierKeyIdExtensionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_keyIdDoesNotExist_notRequired_assertValue0() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("cernerDemosCaCert.der");
        AuthorityKeyIdentifierKeyIdExtensionField field = new AuthorityKeyIdentifierKeyIdExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertEquals((Object)"", (Object)field.getPolicyValue().getPolicyValue());
    }

    @Test
    public void testInjectRefereneValue_keyIdDoesNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("cernerDemosCaCert.der");
        AuthorityKeyIdentifierKeyIdExtensionField field = new AuthorityKeyIdentifierKeyIdExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_keyIdExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        AuthorityKeyIdentifierKeyIdExtensionField field = new AuthorityKeyIdentifierKeyIdExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertEquals((Object)"3aa0074b77b2493efb447de5ce6cd055085de3f0", (Object)field.getPolicyValue().getPolicyValue());
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        AuthorityKeyIdentifierKeyIdExtensionField field = new AuthorityKeyIdentifierKeyIdExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

