/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.CRLDistributionPointNameExtentionField;

public class CRLDistributionPointNameExtentionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_crlPointDoesNotExist_notRequired_assertValueEmpty() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        CRLDistributionPointNameExtentionField field = new CRLDistributionPointNameExtentionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertTrue((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
    }

    @Test
    public void testInjectRefereneValue_crlPointDoesNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        CRLDistributionPointNameExtentionField field = new CRLDistributionPointNameExtentionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_crlPointExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("CernerDirectProviderCA.der");
        CRLDistributionPointNameExtentionField field = new CRLDistributionPointNameExtentionField(false);
        field.injectReferenceValue(cert);
        Collection usages = (Collection)field.getPolicyValue().getPolicyValue();
        Assertions.assertFalse((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
        Assertions.assertTrue((boolean)usages.contains("http://ca.cerner.com/CRL/CERNER-ROOTCA00.crl"));
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        CRLDistributionPointNameExtentionField field = new CRLDistributionPointNameExtentionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

