/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.ExtendedKeyUsageExtensionField;
import org.nhindirect.policy.x509.ExtendedKeyUsageIdentifier;

public class ExtendedKeyUsageExtensionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_extendedKeyUsageDoesNotExist_notRequired_assertValueEmpty() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        ExtendedKeyUsageExtensionField field = new ExtendedKeyUsageExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertTrue((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
    }

    @Test
    public void testInjectRefereneValue_extendedKeyUsageDoesNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        ExtendedKeyUsageExtensionField field = new ExtendedKeyUsageExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_keyUsageExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("mshost.der");
        ExtendedKeyUsageExtensionField field = new ExtendedKeyUsageExtensionField(false);
        field.injectReferenceValue(cert);
        Collection usages = (Collection)field.getPolicyValue().getPolicyValue();
        Assertions.assertFalse((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
        Assertions.assertTrue((boolean)usages.contains(ExtendedKeyUsageIdentifier.ID_KP_EMAIL_PROTECTION.getId()));
        Assertions.assertFalse((boolean)usages.contains(ExtendedKeyUsageIdentifier.ID_KP_CLIENT_AUTH.getId()));
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        ExtendedKeyUsageExtensionField field = new ExtendedKeyUsageExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

