/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.IssuerAttributeField;
import org.nhindirect.policy.x509.RDNAttributeIdentifier;

public class IssuerAttributeField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_rdnAttributeDoesNotExist_notRequired_assertValueCollection() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        IssuerAttributeField field = new IssuerAttributeField(false, RDNAttributeIdentifier.INITIALS);
        field.injectReferenceValue(cert);
        Collection values = (Collection)field.getPolicyValue().getPolicyValue();
        Assertions.assertEquals((int)0, (int)values.size());
    }

    @Test
    public void testInjectRefereneValue_rdnAttributeDoesNotExist_required_throwException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        IssuerAttributeField field = new IssuerAttributeField(true, RDNAttributeIdentifier.INITIALS);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_rdnSingleAttributeExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        IssuerAttributeField field = new IssuerAttributeField(true, RDNAttributeIdentifier.COMMON_NAME);
        field.injectReferenceValue(cert);
        Collection values = (Collection)field.getPolicyValue().getPolicyValue();
        Assertions.assertEquals((int)1, (int)values.size());
        Iterator str = values.iterator();
        Assertions.assertEquals((Object)"test.email.com", str.next());
    }

    @Test
    public void testInjectRefereneValue_distinguishedName_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        IssuerAttributeField field = new IssuerAttributeField(true, RDNAttributeIdentifier.DISTINGUISHED_NAME);
        field.injectReferenceValue(cert);
        Collection values = (Collection)field.getPolicyValue().getPolicyValue();
        Assertions.assertEquals((int)1, (int)values.size());
        Iterator str = values.iterator();
        Assertions.assertEquals((Object)"O=Cerner,L=Kansas City,ST=MO,C=US,CN=test.email.com", str.next());
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        IssuerAttributeField field = new IssuerAttributeField(true, RDNAttributeIdentifier.COMMON_NAME);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

