/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.SubjectAltNameExtensionField;

public class SubjectAltNameExtensionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_subjectAltNameDoesNotExist_notRequired_assertEmptyCollection() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("dsa1024.der");
        SubjectAltNameExtensionField field = new SubjectAltNameExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertEquals((int)0, (int)((Collection)field.getPolicyValue().getPolicyValue()).size());
    }

    @Test
    public void testInjectRefereneValue_subjectAltNameDoesNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("dsa1024.der");
        SubjectAltNameExtensionField field = new SubjectAltNameExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_subjectAltNameExists_rfc822Name_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        SubjectAltNameExtensionField field = new SubjectAltNameExtensionField(false);
        field.injectReferenceValue(cert);
        Collection names = (Collection)field.getPolicyValue().getPolicyValue();
        Assertions.assertEquals((int)1, (int)names.size());
        Assertions.assertEquals((Object)"rfc822:AlAnderson@hospitalA.direct.visionshareinc.com", names.iterator().next());
    }

    @Test
    public void testInjectRefereneValue_subjectAltNameExists_dnsName_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("cernerdemos.der");
        SubjectAltNameExtensionField field = new SubjectAltNameExtensionField(false);
        field.injectReferenceValue(cert);
        Collection names = (Collection)field.getPolicyValue().getPolicyValue();
        Assertions.assertEquals((int)1, (int)names.size());
        Assertions.assertEquals((Object)"dns:messaging.cernerdemos.com", names.iterator().next());
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        SubjectAltNameExtensionField field = new SubjectAltNameExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

