/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.SubjectKeyIdentifierExtensionField;

public class SubjectKeyIdentifierExtensionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_keyIdDoesNotExist_notRequired_assertValue0() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("cernerDemosCaCert.der");
        SubjectKeyIdentifierExtensionField field = new SubjectKeyIdentifierExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertEquals((Object)"", (Object)field.getPolicyValue().getPolicyValue());
    }

    @Test
    public void testInjectRefereneValue_keyIdDoesNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("cernerDemosCaCert.der");
        SubjectKeyIdentifierExtensionField field = new SubjectKeyIdentifierExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_keyIdUsageExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        SubjectKeyIdentifierExtensionField field = new SubjectKeyIdentifierExtensionField(false);
        field.injectReferenceValue(cert);
        Assertions.assertEquals((Object)"e0f63ccfeb5ce3eef5c04efe8084c92bc628682c", (Object)field.getPolicyValue().getPolicyValue());
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        SubjectKeyIdentifierExtensionField field = new SubjectKeyIdentifierExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

