/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.PublicKeyAlgorithmIdentifier;
import org.nhindirect.policy.x509.SubjectPublicKeyAlgorithmField;

public class SubjectPublicKeyAlgorithmField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_rsaAlg_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        SubjectPublicKeyAlgorithmField field = new SubjectPublicKeyAlgorithmField();
        field.injectReferenceValue(cert);
        String value = (String)field.getPolicyValue().getPolicyValue();
        Assertions.assertEquals((Object)PublicKeyAlgorithmIdentifier.RSA.getId(), (Object)value);
    }

    @Test
    public void testInjectRefereneValue_dsaAlg_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("dsa1024.der");
        SubjectPublicKeyAlgorithmField field = new SubjectPublicKeyAlgorithmField();
        field.injectReferenceValue(cert);
        String value = (String)field.getPolicyValue().getPolicyValue();
        Assertions.assertEquals((Object)PublicKeyAlgorithmIdentifier.DSA.getId(), (Object)value);
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        SubjectPublicKeyAlgorithmField field = new SubjectPublicKeyAlgorithmField();
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

