/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.install;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.nhind.config.Anchor;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.Domain;
import org.nhind.config.EntityStatus;
import org.nhindirect.install.AbstractCertCreator;

public class AddDomainCAAndPrivCert {
    public static void main(String[] args) {
        String configServiceUrl = args[0];
        String domainName = args[1];
        String caCommonName = args[2];
        String certCommonName = args[3];
        try {
            ConfigurationServiceProxy cfService = new ConfigurationServiceProxy(configServiceUrl);
            Domain domain = new Domain();
            domain.setDomainName(domainName);
            domain.setPostMasterEmail("postmaster@" + domainName);
            domain.setStatus(EntityStatus.ENABLED);
            cfService.addDomain(domain);
            File caFile = AbstractCertCreator.createNewFileName(caCommonName, false);
            Anchor anchor = new Anchor();
            anchor.setData(FileUtils.readFileToByteArray((File)caFile));
            anchor.setOwner(domainName);
            anchor.setIncoming(true);
            anchor.setOutgoing(true);
            anchor.setStatus(EntityStatus.ENABLED);
            cfService.addAnchor(new Anchor[]{anchor});
            File certFile = AbstractCertCreator.createNewFileName(certCommonName, false);
            String certFileName = certFile.getName();
            int idx = certFileName.lastIndexOf(".der");
            String p12FileName = certFileName.substring(0, idx) + ".p12";
            Certificate cert = new Certificate();
            cert.setData(FileUtils.readFileToByteArray((File)new File(p12FileName)));
            cert.setStatus(EntityStatus.ENABLED);
            cfService.addCertificates(new Certificate[]{cert});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

