/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.install;

import java.io.File;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.nhindirect.install.AbstractCertCreator;
import org.nhindirect.stagent.cert.tools.CreatePKCS12;
import org.nhindirect.stagent.cert.tools.certgen.CertCreateFields;
import org.nhindirect.stagent.cert.tools.certgen.CertGenerator;
import org.nhindirect.stagent.cert.tools.certgen.CertLoader;

public class SubscriberCertCreator
extends AbstractCertCreator {
    protected String caCNField;
    protected String caPass;
    protected String emailField;
    private CertCreateFields signer;
    private X509Certificate signerCert;
    private PrivateKey signerKey;

    public static void main(String[] args) {
        SubscriberCertCreator creator = new SubscriberCertCreator();
        creator.createCert(args);
    }

    @Override
    public void createCert(String[] args) {
        this.expField = args[0];
        this.keyStr = args[1];
        this.pass = args[2];
        this.emailField = args[3];
        this.caCNField = args[4];
        this.caPass = args[5];
        try {
            this.signer = CertLoader.loadCertificate((File)SubscriberCertCreator.createNewFileName(this.caCNField, false), (File)SubscriberCertCreator.createNewFileName(this.caCNField, true), (char[])this.caPass.toCharArray());
            this.signerCert = this.signer.getSignerCert();
            this.signerKey = (PrivateKey)this.signer.getSignerKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("CN", this.emailField);
        attributes.put("EMAILADDRESS", this.emailField);
        attributes.put("ALLOWTOSIGN", false);
        int exp = Integer.parseInt(this.expField);
        int keyStre = Integer.parseInt(this.keyStr);
        CertCreateFields createFields = new CertCreateFields(attributes, SubscriberCertCreator.createNewFileName(this.emailField, false), SubscriberCertCreator.createNewFileName(this.emailField, true), this.pass.toCharArray(), exp, keyStre, this.signerCert, (Key)this.signerKey);
        try {
            CertCreateFields retCert = CertGenerator.createCertificate((CertCreateFields)createFields, (boolean)true);
            CreatePKCS12.create((File)retCert.getNewCertFile(), (File)retCert.getNewKeyFile(), (String)new String(this.pass.toCharArray()), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

