/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.transform.impl;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.xd.common.DirectDocument2;
import org.nhindirect.xd.common.DirectDocuments;
import org.nhindirect.xd.common.XdmPackage;
import org.nhindirect.xd.common.type.DirectDocumentType;
import org.nhindirect.xd.common.type.FormatCodeEnum;
import org.nhindirect.xd.transform.MimeXdsTransformer;
import org.nhindirect.xd.transform.exception.TransformationException;
import org.nhindirect.xd.transform.util.type.MimeType;

public class DefaultMimeXdsTransformer
implements MimeXdsTransformer {
    private byte[] xdsDocument = null;
    private String xdsMimeType = null;
    private FormatCodeEnum xdsFormatCode = null;
    private DirectDocumentType documentType = null;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultMimeXdsTransformer.class);

    @Override
    public ProvideAndRegisterDocumentSetRequestType transform(MimeMessage mimeMessage) throws TransformationException {
        ProvideAndRegisterDocumentSetRequestType request;
        DirectDocuments documents;
        block21: {
            documents = new DirectDocuments();
            try {
                Date sentDate = mimeMessage.getSentDate();
                String subject = mimeMessage.getSubject();
                String from = mimeMessage.getFrom()[0].toString();
                Address[] recipients = mimeMessage.getAllRecipients();
                if (MimeType.TEXT_PLAIN.matches(mimeMessage.getContentType())) {
                    LOGGER.info((Object)("Handling plain mail (no attachments) - " + mimeMessage.getContentType()));
                    this.documentType = DirectDocumentType.lookup(mimeMessage);
                    this.xdsFormatCode = this.documentType.getFormatCode();
                    this.xdsMimeType = this.documentType.getMimeType().getType();
                    this.xdsDocument = ((String)mimeMessage.getContent()).getBytes();
                    documents.getDocuments().add(this.getDocument(sentDate, from));
                    documents.setSubmissionSet(this.getSubmissionSet(subject, sentDate, from, recipients));
                    break block21;
                }
                if (MimeType.MULTIPART.matches(mimeMessage.getContentType())) {
                    BodyPart bodyPart;
                    int i;
                    LOGGER.info((Object)("Handling multipart/mixed - " + mimeMessage.getContentType()));
                    MimeMultipart mimeMultipart = (MimeMultipart)mimeMessage.getContent();
                    BodyPart xdmBodyPart = null;
                    for (i = 0; i < mimeMultipart.getCount(); ++i) {
                        bodyPart = mimeMultipart.getBodyPart(i);
                        this.documentType = DirectDocumentType.lookup(bodyPart);
                        if (!DirectDocumentType.XDM.equals((Object)this.documentType)) continue;
                        xdmBodyPart = bodyPart;
                    }
                    for (i = 0; i < mimeMultipart.getCount(); ++i) {
                        if (xdmBodyPart != null) {
                            XdmPackage xdmPackage = XdmPackage.fromXdmZipDataHandler(xdmBodyPart.getDataHandler());
                            System.out.println("XDM FILE FOUND");
                            documents = xdmPackage.getDocuments();
                            break block21;
                        }
                        bodyPart = mimeMultipart.getBodyPart(i);
                        if (bodyPart.getSize() <= 0) {
                            LOGGER.warn((Object)"Empty body, skipping");
                            continue;
                        }
                        this.documentType = DirectDocumentType.lookup(bodyPart);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)("File name: " + bodyPart.getFileName()));
                        }
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)("Content type: " + bodyPart.getContentType()));
                        }
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)("DocumentType: " + this.documentType.toString()));
                        }
                        this.xdsFormatCode = this.documentType.getFormatCode();
                        this.xdsMimeType = this.documentType.getMimeType().getType();
                        if (DirectDocumentType.UNKNOWN.equals((Object)this.documentType)) {
                            this.xdsMimeType = bodyPart.getContentType();
                        }
                        this.xdsDocument = DefaultMimeXdsTransformer.read(bodyPart);
                        documents.getDocuments().add(this.getDocument(sentDate, from));
                        documents.setSubmissionSet(this.getSubmissionSet(subject, sentDate, from, recipients));
                    }
                    break block21;
                }
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Message content type (" + mimeMessage.getContentType() + ") is not supported, skipping"));
                }
            }
            catch (MessagingException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)"Unexpected MessagingException occured while handling MimeMessage", (Throwable)e);
                }
                throw new TransformationException("Unable to complete transformation.", e);
            }
            catch (IOException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)"Unexpected IOException occured while handling MimeMessage", (Throwable)e);
                }
                throw new TransformationException("Unable to complete transformation.", e);
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)"Unexpected Exception occured while handling MimeMessage", (Throwable)e);
                }
                throw new TransformationException("Unable to complete transformation", e);
            }
        }
        try {
            request = documents.toProvideAndRegisterDocumentSetRequestType();
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Unexpected IOException occured while transforming to ProvideAndRegisterDocumentSetRequestType", (Throwable)e);
            }
            throw new TransformationException("Unable to complete transformation", e);
        }
        return request;
    }

    private DirectDocuments.SubmissionSet getSubmissionSet(String subject, Date sentDate, String auth, Address[] recipients) throws Exception {
        DirectDocuments.SubmissionSet submissionSet = new DirectDocuments.SubmissionSet();
        submissionSet.setAuthorTelecommunication(auth);
        submissionSet.setSourceId("TODO");
        submissionSet.setSubmissionTime(sentDate);
        submissionSet.setUniqueId(UUID.randomUUID().toString());
        for (Address address : recipients) {
            submissionSet.getIntendedRecipient().add("||^^Internet^" + address.toString());
        }
        this.documentType.parse(new String(this.xdsDocument), submissionSet);
        return submissionSet;
    }

    private DirectDocument2 getDocument(Date sentDate, String auth) throws Exception {
        DirectDocument2 document = new DirectDocument2();
        DirectDocument2.Metadata metadata = document.getMetadata();
        metadata.setMimeType(this.xdsMimeType);
        metadata.setUniqueId(UUID.randomUUID().toString());
        if (this.xdsFormatCode != null) {
            metadata.setFormatCode(this.xdsFormatCode);
        }
        this.documentType.parse(new String(this.xdsDocument), metadata);
        document.setData(this.xdsDocument);
        return document;
    }

    private static byte[] read(BodyPart bodyPart) throws MessagingException, IOException {
        InputStream inputStream = bodyPart.getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int data = 0;
        byte[] buffer = new byte[1024];
        while ((data = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, data);
        }
        return outputStream.toByteArray();
    }
}

