/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.xmlpolicy.verifier;

import org.realityforge.salt.i18n.ResourceManager;
import org.realityforge.salt.i18n.Resources;
import org.realityforge.xmlpolicy.metadata.GrantMetaData;
import org.realityforge.xmlpolicy.metadata.KeyStoreMetaData;
import org.realityforge.xmlpolicy.metadata.PermissionMetaData;
import org.realityforge.xmlpolicy.metadata.PolicyMetaData;

public class PolicyVerifier {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$realityforge$xmlpolicy$verifier$PolicyVerifier == null ? (class$org$realityforge$xmlpolicy$verifier$PolicyVerifier = PolicyVerifier.class$("org.realityforge.xmlpolicy.verifier.PolicyVerifier")) : class$org$realityforge$xmlpolicy$verifier$PolicyVerifier));
    static /* synthetic */ Class class$org$realityforge$xmlpolicy$verifier$PolicyVerifier;

    public void verifyPolicy(PolicyMetaData policy) throws Exception {
        String message = null;
        message = REZ.getString("valid-names.notice");
        this.info(message);
        this.verifyNames(policy);
        message = REZ.getString("valid-keyStoreReferences.notice");
        this.info(message);
        this.verifyKeyStoreReferences(policy);
        message = REZ.getString("valid-actions.notice");
        this.info(message);
        this.verifyActions(policy);
    }

    protected void info(String message) {
    }

    private void verifyNames(PolicyMetaData policy) throws Exception {
        KeyStoreMetaData[] keyStores = policy.getKeyStores();
        int i = 0;
        while (i < keyStores.length) {
            String name = keyStores[i].getName();
            this.verifyName(name);
            ++i;
        }
    }

    private void verifyKeyStoreReferences(PolicyMetaData policy) throws Exception {
        GrantMetaData[] grants = policy.getGrants();
        int i = 0;
        while (i < grants.length) {
            this.verifyKeyStore(policy, grants[i]);
            ++i;
        }
    }

    private void verifyKeyStore(PolicyMetaData policy, GrantMetaData grant) throws Exception {
        this.verifyKeyStoreReference(policy, grant.getKeyStore());
        PermissionMetaData[] permissions = grant.getPermissions();
        int j = 0;
        while (j < permissions.length) {
            PermissionMetaData permission = permissions[j];
            this.verifyKeyStoreReference(policy, permission.getKeyStore());
            ++j;
        }
    }

    private void verifyKeyStoreReference(PolicyMetaData policy, String keyStoreName) throws Exception {
        if (null == keyStoreName) {
            return;
        }
        KeyStoreMetaData[] keyStores = policy.getKeyStores();
        int i = 0;
        while (i < keyStores.length) {
            KeyStoreMetaData keyStore = keyStores[i];
            if (keyStore.getName().equals(keyStoreName)) {
                return;
            }
            ++i;
        }
        String message = REZ.getString("bad-keystore-reference.error", (Object)keyStoreName);
        throw new Exception(message);
    }

    private void verifyName(String name) throws Exception {
        int size = name.length();
        if (0 == size) {
            String message = REZ.getString("empty-name.error", (Object)name);
            throw new Exception(message);
        }
        char ch = name.charAt(0);
        if (!Character.isLetter(ch) && '_' != ch) {
            String message = REZ.getString("name-invalid-start.error", (Object)name);
            throw new Exception(message);
        }
        int i = 1;
        while (i < size) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && '_' != c && '-' != c && '.' != c) {
                String message = REZ.getString("name-invalid-char.error", (Object)name, (Object)String.valueOf(c));
                throw new Exception(message);
            }
            ++i;
        }
    }

    private void verifyActions(PolicyMetaData policy) throws Exception {
        GrantMetaData[] grants = policy.getGrants();
        int i = 0;
        while (i < grants.length) {
            GrantMetaData grant = grants[i];
            PermissionMetaData[] permissions = grant.getPermissions();
            int j = 0;
            while (j < permissions.length) {
                PermissionMetaData permission = permissions[j];
                String target = permission.getTarget();
                String action = permission.getAction();
                if (null == target && null != action) {
                    String message = REZ.getString("permission-missing-action.error", (Object)grant.getCodebase(), (Object)permission.getClassname());
                    throw new Exception(message);
                }
                ++j;
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

