/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.dao.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Setting;
import org.nhindirect.config.store.dao.SettingDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SettingDaoImpl
implements SettingDao {
    @PersistenceContext
    @Autowired
    private EntityManager entityManager;
    private static final Log log = LogFactory.getLog(SettingDaoImpl.class);

    @Override
    @Transactional(readOnly=false)
    public void add(String name, String value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (name == null || name.isEmpty() || value == null) {
            return;
        }
        if (this.getByNames(Arrays.asList(name)).size() > 0) {
            throw new ConfigurationStoreException("Setting " + name + " already exists.");
        }
        Setting setting = new Setting();
        setting.setName(name);
        setting.setValue(value);
        setting.setCreateTime(Calendar.getInstance());
        setting.setUpdateTime(setting.getCreateTime());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling JPA to persist the setting");
        }
        this.entityManager.persist((Object)setting);
        this.entityManager.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returned from JPA: Setting ID=" + setting.getId()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(Collection<String> names) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (names != null && names.size() > 0) {
            StringBuffer queryNames = new StringBuffer("(");
            for (String name : names) {
                if (queryNames.length() > 1) {
                    queryNames.append(", ");
                }
                queryNames.append("'").append(name.toUpperCase(Locale.getDefault())).append("'");
            }
            queryNames.append(")");
            String query = "DELETE FROM Setting s WHERE UPPER(s.name) IN " + queryNames.toString();
            int count = 0;
            Query delete = this.entityManager.createQuery(query);
            count = delete.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: " + count + " setting records deleted"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    public Collection<Setting> getAll() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = Collections.emptyList();
        Query select = null;
        select = this.entityManager.createQuery("SELECT s from Setting s");
        List rs = select.getResultList();
        if (rs != null && rs.size() != 0 && rs.get(0) instanceof Setting) {
            result = rs;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    public Collection<Setting> getByNames(Collection<String> names) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (names == null || names.size() == 0) {
            return this.getAll();
        }
        List result = Collections.emptyList();
        Query select = null;
        StringBuffer nameList = new StringBuffer("(");
        for (String name : names) {
            if (nameList.length() > 1) {
                nameList.append(", ");
            }
            nameList.append("'").append(name.toUpperCase(Locale.getDefault())).append("'");
        }
        nameList.append(")");
        String query = "SELECT s from Setting s WHERE UPPER(s.name) IN " + nameList.toString();
        select = this.entityManager.createQuery(query);
        List rs = select.getResultList();
        if (rs != null && rs.size() != 0 && rs.get(0) instanceof Setting) {
            result = rs;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=false)
    public void update(String name, String value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (name == null || name.isEmpty()) {
            return;
        }
        Collection<Setting> settings = this.getByNames(Arrays.asList(name));
        for (Setting setting : settings) {
            setting.setValue(value);
            setting.setUpdateTime(Calendar.getInstance());
            this.entityManager.merge((Object)setting);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }
}

