/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.packagemanager.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.avalon.excalibur.extension.Extension;
import org.apache.avalon.excalibur.packagemanager.ExtensionManager;
import org.apache.avalon.excalibur.packagemanager.OptionalPackage;
import org.apache.avalon.excalibur.packagemanager.impl.OptionalPackageComparator;

public class DelegatingExtensionManager
implements ExtensionManager {
    private final ArrayList m_extensionManagers = new ArrayList();

    public DelegatingExtensionManager() {
    }

    public DelegatingExtensionManager(ExtensionManager[] extensionManagers) {
        int i = 0;
        while (i < extensionManagers.length) {
            this.addExtensionManager(extensionManagers[i]);
            ++i;
        }
    }

    protected synchronized void addExtensionManager(ExtensionManager extensionManager) {
        if (!this.m_extensionManagers.contains(extensionManager)) {
            this.m_extensionManagers.add(extensionManager);
        }
    }

    protected void addPackageRepository(ExtensionManager extensionManager) {
        this.addExtensionManager(extensionManager);
    }

    protected synchronized void removeExtensionManager(ExtensionManager repository) {
        this.m_extensionManagers.remove(repository);
    }

    protected void removePackageRepository(ExtensionManager extensionManager) {
        this.removeExtensionManager(extensionManager);
    }

    public synchronized OptionalPackage[] getOptionalPackages(Extension extension) {
        ArrayList<OptionalPackage> resultPackages = new ArrayList<OptionalPackage>();
        int size = this.m_extensionManagers.size();
        int i = 0;
        while (i < size) {
            ExtensionManager repository = (ExtensionManager)this.m_extensionManagers.get(i);
            OptionalPackage[] packages = repository.getOptionalPackages(extension);
            if (null != packages && 0 != packages.length) {
                int j = 0;
                while (j < packages.length) {
                    resultPackages.add(packages[j]);
                    ++j;
                }
            }
            ++i;
        }
        OptionalPackageComparator comparator = new OptionalPackageComparator(extension.getExtensionName());
        Collections.sort(resultPackages, comparator);
        OptionalPackage[] resultData = new OptionalPackage[resultPackages.size()];
        return resultPackages.toArray(resultData);
    }
}

