/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.comparators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.comparators.Comparator;
import org.apache.jsieve.exception.LookupException;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SievePatternException;

public class ComparatorUtils {
    private ComparatorUtils() {
    }

    public static boolean match(String comparatorName, String matchType, String matchTarget, String matchArgument, SieveContext context) throws SieveException {
        boolean isMatched = false;
        if (matchType.equals(":is")) {
            isMatched = ComparatorUtils.is(comparatorName, matchTarget, matchArgument, context);
        } else if (matchType.equals(":contains")) {
            isMatched = ComparatorUtils.contains(comparatorName, matchTarget, matchArgument, context);
        } else if (matchType.equals(":matches")) {
            isMatched = ComparatorUtils.matches(comparatorName, matchTarget, matchArgument, context);
        }
        return isMatched;
    }

    public static boolean matches(String string, String glob) throws SievePatternException {
        try {
            String regex = ComparatorUtils.sieveToJavaRegex(glob);
            Matcher matcher = Pattern.compile(regex).matcher(string);
            return matcher.matches();
        }
        catch (PatternSyntaxException e) {
            throw new SievePatternException(e.getMessage());
        }
    }

    public static boolean contains(String container, String contents) {
        return container.indexOf(contents) > -1;
    }

    public static boolean equals(String string1, String string2) {
        return string1.equals(string2);
    }

    private static boolean isRegexSpecialChar(char ch) {
        return ch == '*' || ch == '?' || ch == '+' || ch == '[' || ch == ']' || ch == '(' || ch == ')' || ch == '|' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '\\';
    }

    private static boolean isSieveMatcherSpecialChar(char ch) {
        return ch == '*' || ch == '?' || ch == '\\';
    }

    public static String sieveToJavaRegex(String pattern) {
        StringBuffer buffer = new StringBuffer(2 * pattern.length());
        boolean lastCharWasStar = false;
        for (int ch = 0; ch < pattern.length(); ++ch) {
            char nextChar = pattern.charAt(ch);
            switch (nextChar) {
                case '*': {
                    if (lastCharWasStar) break;
                    buffer.append(".*");
                    break;
                }
                case '?': {
                    buffer.append('.');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    if (ch == pattern.length() - 1) {
                        buffer.append('\\');
                        break;
                    }
                    if (ComparatorUtils.isSieveMatcherSpecialChar(pattern.charAt(ch + 1))) {
                        buffer.append(pattern.charAt(++ch));
                        break;
                    }
                    buffer.append('\\');
                    break;
                }
                default: {
                    if (ComparatorUtils.isRegexSpecialChar(nextChar)) {
                        buffer.append('\\');
                    }
                    buffer.append(nextChar);
                }
            }
            lastCharWasStar = '*' == nextChar;
        }
        return buffer.toString();
    }

    public static boolean contains(String comparatorName, String container, String contents, SieveContext context) throws SieveException {
        Comparator comparatorObj = context.getComparatorManager().getComparator(comparatorName);
        return comparatorObj.contains(container, contents);
    }

    public static boolean is(String comparatorName, String string1, String string2, SieveContext context) throws LookupException {
        Comparator comparatorObj = context.getComparatorManager().getComparator(comparatorName);
        return comparatorObj.equals(string1, string2);
    }

    public static boolean matches(String comparatorName, String string, String glob, SieveContext context) throws SieveException {
        Comparator comparatorObj = context.getComparatorManager().getComparator(comparatorName);
        return comparatorObj.matches(string, glob);
    }
}

