/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.james.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.GenericMatcher;

public class RecipientIsLocalAndSMTPAuthUserIs
extends GenericMatcher {
    private static final String SMTP_AUTH_USER_ATTRIBUTE_NAME = "org.apache.james.SMTPAuthUser";
    private static final Log LOGGER = LogFactory.getFactory().getInstance(RecipientIsLocalAndSMTPAuthUserIs.class);
    private String user;

    public void init() throws MessagingException {
        this.user = this.getCondition();
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        LOGGER.info((Object)"Servicing RecipientIsLocalAndSMTPAuthUserIs matcher");
        String authUser = (String)((Object)mail.getAttribute(SMTP_AUTH_USER_ATTRIBUTE_NAME));
        if (authUser == null || !StringUtils.equalsIgnoreCase((String)this.user, (String)authUser)) {
            LOGGER.info((Object)("Auth user is not " + this.user + ", skipping"));
            return Collections.emptyList();
        }
        MailetContext mailetContext = this.getMailetContext();
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
        for (MailAddress recipient : mail.getRecipients()) {
            if (!mailetContext.isLocalServer(recipient.getHost()) || !mailetContext.isLocalUser(recipient.getUser())) continue;
            recipients.add(recipient);
        }
        if (recipients.isEmpty()) {
            LOGGER.info((Object)"Matched no recipients");
        } else {
            for (MailAddress addr : recipients) {
                LOGGER.info((Object)("Matched recipient " + addr.toString()));
            }
        }
        return recipients;
    }
}

