/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.jsieve.mailet.mdn.Disposition;
import org.apache.mailet.base.mail.MimeMultipartReport;
import org.nhindirect.stagent.mail.notifications.MdnGateway;

public class MDNFactory {
    private MDNFactory() {
    }

    public static MimeMultipartReport create(String humanText, String reporting_UA_name, String reporting_UA_product, String original_recipient, String final_recipient, String original_message_id, String error, MdnGateway gateway, Disposition disposition) throws MessagingException {
        if (disposition == null) {
            throw new IllegalArgumentException("Disposition can not be null.");
        }
        MimeMultipartReport multiPart = new MimeMultipartReport();
        multiPart.setReportType("disposition-notification");
        MimeBodyPart humanPart = new MimeBodyPart();
        humanPart.setText(humanText);
        multiPart.addBodyPart((BodyPart)humanPart);
        StringBuilder mdnReport = new StringBuilder(128);
        if (reporting_UA_name != null && !reporting_UA_name.isEmpty()) {
            mdnReport.append("Reporting-UA: ");
            mdnReport.append(reporting_UA_name == null ? "" : reporting_UA_name);
            mdnReport.append("; ");
            mdnReport.append(reporting_UA_product == null ? "" : reporting_UA_product);
            mdnReport.append("\r\n");
        }
        if (original_recipient != null && !original_recipient.isEmpty()) {
            mdnReport.append("Original-Recipient: ");
            mdnReport.append("rfc822; ");
            mdnReport.append(original_recipient);
            mdnReport.append("\r\n");
        }
        if (final_recipient != null && !final_recipient.isEmpty()) {
            mdnReport.append("Final-Recipient: ");
            mdnReport.append("rfc822; ");
            mdnReport.append(final_recipient);
            mdnReport.append("\r\n");
        }
        if (original_message_id != null && !original_message_id.isEmpty()) {
            mdnReport.append("Original-Message-ID: ");
            mdnReport.append(original_message_id);
            mdnReport.append("\r\n");
        }
        if (gateway != null) {
            mdnReport.append("MDN-Gateway: ");
            mdnReport.append(gateway.toString());
            mdnReport.append("\r\n");
        }
        if (error != null && !error.isEmpty()) {
            mdnReport.append("Error: ");
            mdnReport.append(error);
            mdnReport.append("\r\n");
        }
        mdnReport.append(disposition.toString());
        mdnReport.append("\r\n");
        MimeBodyPart mdnPart = new MimeBodyPart();
        try {
            ByteArrayDataSource dataSource = new ByteArrayDataSource((InputStream)new ByteArrayInputStream(mdnReport.toString().getBytes()), "message/disposition-notification");
            mdnPart.setDataHandler(new DataHandler((DataSource)dataSource));
            multiPart.addBodyPart((BodyPart)mdnPart);
        }
        catch (IOException e) {
            // empty catch block
        }
        return multiPart;
    }
}

