/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.mail.dsn;

import com.sun.mail.dsn.DeliveryStatus;
import com.sun.mail.dsn.MultipartReport;
import com.sun.mail.dsn.Report;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.nhindirect.common.mail.dsn.DSNMessageHeaders;
import org.nhindirect.common.mail.dsn.DSNRecipientHeaders;
import org.nhindirect.common.mail.dsn.DSNStandard;

public class DSNGenerator {
    private static final int DELIVERY_STATUS_MULTIPART_INDEX = 1;
    protected final String subjectPrefix;

    public DSNGenerator(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public MimeMessage createDSNMessage(InternetAddress originalSender, String originalSubject, InternetAddress postmaster, List<DSNRecipientHeaders> recipientDSNHeaders, DSNMessageHeaders messageDSNHeaders, MimeBodyPart humanReadableText) throws MessagingException {
        DeliveryStatus deliveryStatus = this.createDeliveryStatus(recipientDSNHeaders, messageDSNHeaders);
        MultipartReport multipartReport = new MultipartReport("", (Report)deliveryStatus);
        multipartReport.getBodyPart(1).setFileName("status.dat");
        multipartReport.setTextBodyPart(humanReadableText);
        Properties properties = new Properties();
        properties.setProperty("mail.from", postmaster.getAddress());
        Session session = Session.getInstance((Properties)properties);
        MimeMessage destinationMessage = new MimeMessage(session);
        destinationMessage.setContent((Multipart)multipartReport);
        destinationMessage.setFrom((Address)postmaster);
        destinationMessage.addRecipient(Message.RecipientType.TO, (Address)originalSender);
        destinationMessage.setSubject(this.subjectPrefix + originalSubject);
        destinationMessage.setHeader("in-reply-to", messageDSNHeaders.getOriginalMessageId());
        destinationMessage.saveChanges();
        return destinationMessage;
    }

    protected DeliveryStatus createDeliveryStatus(List<DSNRecipientHeaders> recipientDSNHeaders, DSNMessageHeaders messageDSNHeaders) throws MessagingException {
        DeliveryStatus deliveryStatus = new DeliveryStatus();
        for (DSNRecipientHeaders dsnHeaders : recipientDSNHeaders) {
            InternetHeaders recipHeaders = new InternetHeaders();
            DSNStandard.DSNAction dsnAction = dsnHeaders.getAction();
            recipHeaders.addHeader("Action", "" + (Object)((Object)dsnAction));
            Address finalRecipient = dsnHeaders.getFinalRecipient();
            if (finalRecipient != null) {
                recipHeaders.addHeader("Final-Recipient", finalRecipient.getType() + ";" + finalRecipient.toString());
            }
            String status = dsnHeaders.getStatus();
            recipHeaders.addHeader("Status", status);
            deliveryStatus.addRecipientDSN(recipHeaders);
        }
        InternetHeaders messageHeaders = new InternetHeaders();
        DSNStandard.MtaNameType mtaNameType = messageDSNHeaders.getMtaNameType();
        String reportingMta = messageDSNHeaders.getReportingMta();
        messageHeaders.addHeader("Reporting-MTA", (Object)((Object)mtaNameType) + ";" + reportingMta);
        String originalMessageId = messageDSNHeaders.getOriginalMessageId();
        messageHeaders.addHeader("X-Original-Message-ID", originalMessageId);
        deliveryStatus.setMessageDSN(messageHeaders);
        return deliveryStatus;
    }
}

