/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.impl;

import com.sun.mail.dsn.DeliveryStatus;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.mail.MDNStandard;
import org.nhindirect.common.mail.MailStandard;
import org.nhindirect.common.mail.MailUtil;
import org.nhindirect.common.mail.dsn.DSNStandard;
import org.nhindirect.common.tx.TxDetailParser;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;

public class DefaultTxDetailParser
implements TxDetailParser {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultTxDetailParser.class);

    @Override
    public Map<String, TxDetail> getMessageDetails(InternetHeaders headers) {
        Map<String, TxDetail> retVal = null;
        try {
            MimeMessage msg = new MimeMessage((Session)null);
            Enumeration henum = headers.getAllHeaderLines();
            while (henum.hasMoreElements()) {
                msg.addHeaderLine((String)henum.nextElement());
            }
            retVal = this.getMessageDetails(msg);
        }
        catch (MessagingException e) {
            LOGGER.warn((Object)"Failed to translate headers to MimeMessage.", (Throwable)e);
        }
        return retVal;
    }

    @Override
    public Map<String, TxDetail> getMessageDetails(InputStream stream) {
        Map<String, TxDetail> retVal = null;
        if (stream == null) {
            throw new IllegalArgumentException("Input stream cannot be null");
        }
        try {
            MimeMessage msg = new MimeMessage(null, stream);
            retVal = this.getMessageDetails(msg);
        }
        catch (MessagingException e) {
            LOGGER.warn((Object)"Failed to translate input stream into MimeMessage.", (Throwable)e);
        }
        return retVal;
    }

    @Override
    public Map<String, TxDetail> getMessageDetails(MimeMessage msg) {
        String dispOption;
        String fullHeaders;
        String subject;
        HashMap<String, TxDetail> retVal = new HashMap<String, TxDetail>();
        String msgId = MailStandard.getHeader(msg, "message-id");
        if (!msgId.isEmpty()) {
            retVal.put(TxDetailType.MSG_ID.getType(), new TxDetail(TxDetailType.MSG_ID.getType(), msgId));
        }
        if (!(subject = MailStandard.getHeader(msg, "subject")).isEmpty()) {
            retVal.put(TxDetailType.SUBJECT.getType(), new TxDetail(TxDetailType.SUBJECT.getType(), subject));
        }
        if (!(fullHeaders = this.getHeadersAsStringInternal(msg)).isEmpty()) {
            retVal.put(TxDetailType.MSG_FULL_HEADERS.getType(), new TxDetail(TxDetailType.MSG_FULL_HEADERS.getType(), fullHeaders));
        }
        try {
            String from = MailStandard.getHeader(msg, "from");
            if (!from.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                int cnt = 0;
                for (InternetAddress addr : (InternetAddress[])msg.getFrom()) {
                    if (cnt > 0) {
                        builder.append(",");
                    }
                    builder.append(addr.getAddress().toLowerCase(Locale.getDefault()));
                    ++cnt;
                }
                retVal.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM.getType(), builder.toString()));
            }
        }
        catch (MessagingException e) {
            LOGGER.warn((Object)"Failed to retrieve message sender list.", (Throwable)e);
        }
        try {
            InternetAddress sender = (InternetAddress)msg.getSender();
            if (sender != null) {
                retVal.put(TxDetailType.SENDER.getType(), new TxDetail(TxDetailType.SENDER.toString(), sender.getAddress().toLowerCase(Locale.getDefault())));
            }
        }
        catch (MessagingException e) {
            LOGGER.warn((Object)"Failed to retrieve message sender", (Throwable)e);
        }
        try {
            if (msg.getAllRecipients() != null) {
                StringBuilder builder = new StringBuilder();
                int cnt = 0;
                for (Address addr : msg.getAllRecipients()) {
                    if (cnt > 0) {
                        builder.append(",");
                    }
                    if (addr instanceof InternetAddress) {
                        builder.append(((InternetAddress)addr).getAddress().toLowerCase(Locale.getDefault()));
                    }
                    ++cnt;
                }
                retVal.put(TxDetailType.RECIPIENTS.getType(), new TxDetail(TxDetailType.RECIPIENTS.getType(), builder.toString()));
            }
        }
        catch (MessagingException e) {
            LOGGER.warn((Object)"Failed to retrieve message recipient list.", (Throwable)e);
        }
        TxMessageType messageType = TxUtil.getMessageType(msg);
        if (messageType != TxMessageType.UNKNOWN) {
            switch (messageType) {
                case MDN: {
                    String origMsgId;
                    String finalRecipient;
                    String disposition = MDNStandard.getMDNField(msg, "Disposition");
                    if (!disposition.isEmpty()) {
                        retVal.put(TxDetailType.DISPOSITION.getType(), new TxDetail(TxDetailType.DISPOSITION.getType(), disposition.toLowerCase(Locale.getDefault())));
                    }
                    if (!(finalRecipient = MDNStandard.getMDNField(msg, "Final-Recipient")).isEmpty()) {
                        retVal.put(TxDetailType.FINAL_RECIPIENTS.getType(), new TxDetail(TxDetailType.FINAL_RECIPIENTS.getType(), finalRecipient.toLowerCase(Locale.getDefault())));
                    }
                    if ((origMsgId = MDNStandard.getMDNField(msg, "Original-Message-ID")).isEmpty()) {
                        origMsgId = MailStandard.getHeader(msg, "in-reply-to");
                    }
                    if (origMsgId.isEmpty()) break;
                    retVal.put(TxDetailType.PARENT_MSG_ID.getType(), new TxDetail(TxDetailType.PARENT_MSG_ID.getType(), origMsgId));
                    break;
                }
                case DSN: {
                    try {
                        String dsnStatus;
                        String action;
                        String parentMsgId;
                        DeliveryStatus status = new DeliveryStatus((InputStream)new ByteArrayInputStream(MailUtil.serializeToBytes((MimePart)msg)));
                        retVal.put(TxDetailType.FINAL_RECIPIENTS.getType(), new TxDetail(TxDetailType.FINAL_RECIPIENTS.getType(), DSNStandard.getFinalRecipients(status).toLowerCase(Locale.getDefault())));
                        boolean parentFound = false;
                        String origMsgId = DSNStandard.getHeaderValueFromDeliveryStatus(status, "X-Original-Message-ID");
                        if (!origMsgId.isEmpty()) {
                            parentFound = true;
                            retVal.put(TxDetailType.PARENT_MSG_ID.getType(), new TxDetail(TxDetailType.PARENT_MSG_ID, origMsgId));
                        }
                        if (!parentFound && !(parentMsgId = MailStandard.getHeader(msg, "in-reply-to")).isEmpty()) {
                            retVal.put(TxDetailType.PARENT_MSG_ID.getType(), new TxDetail(TxDetailType.PARENT_MSG_ID.getType(), parentMsgId));
                        }
                        if (!(action = DSNStandard.getHeaderValueFromDeliveryStatus(status, "Action")).isEmpty()) {
                            retVal.put(TxDetailType.DSN_ACTION.getType(), new TxDetail(TxDetailType.DSN_ACTION.getType(), action.toLowerCase(Locale.getDefault())));
                        }
                        if ((dsnStatus = DSNStandard.getHeaderValueFromDeliveryStatus(status, "Status")).isEmpty()) break;
                        retVal.put(TxDetailType.DSN_STATUS.getType(), new TxDetail(TxDetailType.DSN_STATUS.getType(), dsnStatus.toLowerCase(Locale.getDefault())));
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"Could not get a requested field from the DSN message", (Throwable)e);
                    }
                }
            }
        }
        if (!(dispOption = MailStandard.getHeader(msg, "Disposition-Notification-Options")).isEmpty()) {
            retVal.put(TxDetailType.DISPOSITION_OPTIONS.getType(), new TxDetail(TxDetailType.DISPOSITION_OPTIONS.getType(), dispOption.toLowerCase(Locale.getDefault())));
        }
        return retVal;
    }

    protected String getHeadersAsStringInternal(MimeMessage msg) {
        return DefaultTxDetailParser.getHeadersAsString(msg);
    }

    public static String getHeadersAsString(MimeMessage msg) {
        StringBuilder builder = new StringBuilder();
        try {
            Enumeration headers = msg.getAllHeaderLines();
            while (headers.hasMoreElements()) {
                builder.append((String)headers.nextElement()).append("\r\n");
            }
        }
        catch (MessagingException e) {
            LOGGER.warn((Object)"Failed to builder message summary.", (Throwable)e);
        }
        return builder.toString();
    }
}

