/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.impl;

import java.io.IOException;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.codehaus.jackson.map.ObjectMapper;
import org.nhindirect.common.rest.UnsecuredServiceRequestBase;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.tx.TxDetailParser;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;

public class SuppressNotificationRequest
extends UnsecuredServiceRequestBase<Boolean, RuntimeException> {
    private final Tx notificationMessage;
    private final TxDetailParser parser;
    protected final Log LOGGER = LogFactory.getFactory().getInstance(SuppressNotificationRequest.class);

    public static String getOriginalMessageId(Tx tx, TxDetailParser parser) {
        if (tx == null) {
            throw new IllegalArgumentException("Invalid parameter received. Tx cannot be null.");
        }
        TxMessageType type = tx.getMsgType();
        if (type != TxMessageType.DSN && type != TxMessageType.MDN) {
            return "";
        }
        TxDetail detail = tx.getDetail(TxDetailType.PARENT_MSG_ID);
        return detail != null && !detail.getDetailValue().isEmpty() ? detail.getDetailValue() : "";
    }

    protected static Tx convertMimeMessageToTx(MimeMessage msg, TxDetailParser parser) {
        if (msg == null) {
            throw new IllegalArgumentException("Invalid parameter received. Message cannot be null.");
        }
        Map<String, TxDetail> details = parser.getMessageDetails(msg);
        return new Tx(TxUtil.getMessageType(msg), details);
    }

    public SuppressNotificationRequest(HttpClient httpClient, String txServiceUrl, ObjectMapper jsonMapper, TxDetailParser parser, MimeMessage msg) {
        this(httpClient, txServiceUrl, jsonMapper, parser, SuppressNotificationRequest.convertMimeMessageToTx(msg, parser));
    }

    public SuppressNotificationRequest(HttpClient httpClient, String txServiceUrl, ObjectMapper jsonMapper, TxDetailParser parser, Tx notificationMessage) {
        super(httpClient, txServiceUrl, jsonMapper);
        if (notificationMessage == null) {
            throw new IllegalArgumentException("Notification message id cannot be null");
        }
        if (parser == null) {
            throw new IllegalArgumentException("Parser cannot be null");
        }
        this.parser = parser;
        this.notificationMessage = notificationMessage;
    }

    private String getRequestUri() {
        String theURI = this.serviceUrl.endsWith("/") ? this.serviceUrl : this.serviceUrl + "/";
        theURI = theURI + "txs/suppressNotification/";
        return theURI;
    }

    @Override
    public Boolean call() throws RuntimeException, IOException, ServiceException {
        String originalMessageId = SuppressNotificationRequest.getOriginalMessageId(this.notificationMessage, this.parser);
        if (originalMessageId == null || originalMessageId.isEmpty()) {
            return false;
        }
        return (Boolean)super.call();
    }

    protected final HttpPost createRequest() throws IOException {
        HttpPost post = new HttpPost(this.getRequestUri());
        post.setHeader("Accept", "application/json");
        return this.buildEntityRequest(post, this.makeContent(), "application/json");
    }

    private byte[] makeContent() throws IOException {
        return this.jsonMapper.writeValueAsBytes((Object)this.notificationMessage);
    }

    @Override
    protected Boolean parseResponse(HttpEntity response) throws IOException {
        try {
            this.checkContentType("application/json", response);
        }
        catch (ServiceException e) {
            throw new IOException("Returned media type is not application/json", e);
        }
        return (Boolean)this.jsonMapper.readValue(response.getContent(), Boolean.class);
    }

    @Override
    public void destroy() {
    }
}

