/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import mx4j.adaptor.http.HttpException;
import mx4j.adaptor.http.HttpInputStream;
import mx4j.adaptor.http.HttpOutputStream;
import mx4j.adaptor.http.ProcessorMBean;
import mx4j.log.Log;
import mx4j.log.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultProcessor
implements ProcessorMBean {
    private static final String ENCODING = "UTF-8";
    private boolean canonical = false;

    public String getName() {
        return "Default XML Processor";
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public void writeResponse(HttpOutputStream out, HttpInputStream in, Document document) throws IOException {
        out.setCode(200);
        out.setHeader("Content-Type", "text/xml");
        out.sendHeaders();
        this.print(new PrintWriter(out), document);
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        this.print(new PrintWriter(o), document);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info(new String(o.toByteArray()));
        }
    }

    public void writeError(HttpOutputStream out, HttpInputStream in, Exception e) throws IOException {
        if (e instanceof HttpException) {
            out.setCode(((HttpException)e).getCode());
            out.setHeader("Content-Type", "text/xml");
            out.sendHeaders();
            this.print(new PrintWriter(out), ((HttpException)e).getResponseDoc());
        }
    }

    public String preProcess(String path) {
        if (path.equals("/")) {
            path = "/server";
        }
        return path;
    }

    public String notFoundElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, HttpException {
        throw new HttpException(404, "Path " + path + " not found");
    }

    protected void print(PrintWriter out, Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                NodeList children = node.getChildNodes();
                int iChild = 0;
                while (iChild < children.getLength()) {
                    this.print(out, children.item(iChild));
                    ++iChild;
                }
                out.flush();
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    out.print(' ');
                    out.print(attr.getNodeName());
                    out.print("=\"");
                    out.print(this.normalize(attr.getNodeValue()));
                    out.print('\"');
                    ++i;
                }
                out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i2 = 0;
                while (i2 < len) {
                    this.print(out, children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.print(out, children.item(i));
                        ++i;
                    }
                    break;
                }
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.println("?>");
                break;
            }
        }
        if (type == 1) {
            out.print("</");
            out.print(node.getNodeName());
            out.print('>');
        }
        out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\'': {
                    str.append("&apos;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }
}

