/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.interceptor;

import mx4j.adaptor.interceptor.AdaptorInterceptor;
import mx4j.adaptor.interceptor.AdaptorInterceptorException;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.adaptor.interceptor.InvocationResult;
import mx4j.log.Logger;

public class LoggerAdaptorInterceptor
extends AdaptorInterceptor {
    public LoggerAdaptorInterceptor() {
        this.setEnabled(true);
    }

    public String getType() {
        return "logger";
    }

    public InvocationResult invoke(Invocation invocation) throws Exception {
        Logger logger = this.getLogger();
        try {
            InvocationResult result = this.doInvoke(invocation);
            if (logger.isEnabledFor(10)) {
                logger.debug("Result is: " + result);
            }
            return result;
        }
        catch (AdaptorInterceptorException x) {
            Exception xx = x.getTargetException();
            if (logger.isEnabledFor(20)) {
                logger.info("", xx);
            }
            throw xx;
        }
        catch (Exception x) {
            logger.info("", x);
            throw x;
        }
        catch (Error x) {
            logger.error("", x);
            throw x;
        }
    }
}

