/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.thread.impl;

import org.apache.excalibur.thread.Executable;
import org.apache.excalibur.thread.ThreadControl;
import org.apache.excalibur.thread.impl.AbstractThreadPool;
import org.apache.excalibur.thread.impl.DefaultThreadControl;

public class WorkerThread
extends Thread {
    private static final boolean ENABLE_DEBUG = false;
    private static final boolean ENABLE_DETAIL_DEBUG = false;
    private Executable m_work;
    private DefaultThreadControl m_threadControl;
    private boolean m_alive;
    private boolean m_clearInterruptFlag;
    private final AbstractThreadPool m_pool;

    protected WorkerThread(AbstractThreadPool pool, ThreadGroup group, String name) {
        super(group, "");
        if (null == name) {
            throw new NullPointerException("name");
        }
        if (null == pool) {
            throw new NullPointerException("pool");
        }
        this.setName(name);
        this.m_work = null;
        this.m_alive = true;
        this.m_clearInterruptFlag = false;
        this.m_pool = pool;
        this.setDaemon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void run() {
        this.debug("starting.");
        try {
            while (this.m_alive) {
                Object var3_3;
                this.waitForWork();
                if (!this.m_alive) continue;
                this.detailDebug("start with work: " + this.m_work);
                try {
                    try {
                        this.preExecute();
                        this.m_work.execute();
                        this.m_threadControl.finish(null);
                    }
                    catch (ThreadDeath threadDeath) {
                        this.debug("thread has died.");
                        this.m_threadControl.finish(threadDeath);
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        this.debug("error caught", throwable);
                        this.m_threadControl.finish(throwable);
                    }
                    var3_3 = null;
                    this.detailDebug("done with work: " + this.m_work);
                    this.m_work = null;
                    this.m_threadControl = null;
                    if (this.m_clearInterruptFlag) {
                        this.clearInterruptFlag();
                    }
                    this.postExecute();
                }
                catch (Throwable throwable) {
                    var3_3 = null;
                    this.detailDebug("done with work: " + this.m_work);
                    this.m_work = null;
                    this.m_threadControl = null;
                    if (this.m_clearInterruptFlag) {
                        this.clearInterruptFlag();
                    }
                    this.postExecute();
                    throw throwable;
                }
                this.notify();
                this.recycleThread();
            }
        }
        finally {
            this.debug("stopped.");
        }
    }

    protected void recycleThread() {
        if (!this.m_alive) {
            throw new IllegalStateException("Attempted to recycle dead thread.");
        }
        this.detailDebug("recycle.");
        if (this.m_clearInterruptFlag) {
            this.clearInterruptFlag();
        }
        this.m_pool.releaseWorker(this);
    }

    protected void postExecute() {
    }

    protected void preExecute() {
        this.clearInterruptFlag();
    }

    public void clearInterruptFlag() {
        if (Thread.currentThread().equals(this)) {
            Thread.interrupted();
            this.m_clearInterruptFlag = false;
        } else {
            this.m_clearInterruptFlag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.debug("destroying.");
        this.m_alive = false;
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            this.notify();
        }
        this.debug("destroyed.");
    }

    protected synchronized ThreadControl execute(Executable work) {
        this.m_work = work;
        this.m_threadControl = new DefaultThreadControl(this);
        this.detailDebug("notifying this worker of new work: " + work.toString());
        this.notify();
        return this.m_threadControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAndWait(Executable work) {
        this.execute(work);
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            while (null != this.m_work) {
                try {
                    this.detailDebug("waiting for work to complete.");
                    this.wait();
                    this.detailDebug("notified.");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWork() {
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            while (this.m_alive && null == this.m_work) {
                try {
                    this.detailDebug("waiting for work.");
                    this.wait();
                    this.detailDebug("notified.");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void debug(String message) {
    }

    protected void debug(String message, Throwable throwable) {
    }

    protected void detailDebug(String message) {
    }

    protected void detailDebug(String message, Throwable throwable) {
    }
}

