/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.kernel;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.DefaultServiceManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.phoenix.components.application.DefaultApplication;
import org.apache.avalon.phoenix.components.kernel.DefaultApplicationContext;
import org.apache.avalon.phoenix.components.kernel.SarEntry;
import org.apache.avalon.phoenix.containerkit.profile.PartitionProfile;
import org.apache.avalon.phoenix.interfaces.Application;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.avalon.phoenix.interfaces.ConfigurationRepository;
import org.apache.avalon.phoenix.interfaces.ConfigurationValidator;
import org.apache.avalon.phoenix.interfaces.Kernel;
import org.apache.avalon.phoenix.interfaces.KernelMBean;
import org.apache.avalon.phoenix.interfaces.SystemManager;
import org.apache.excalibur.instrument.InstrumentManager;
import org.realityforge.loggerstore.LoggerStore;

public class DefaultKernel
extends AbstractLogEnabled
implements Kernel,
KernelMBean,
Initializable,
Serviceable,
Disposable,
Configurable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$kernel$DefaultKernel == null ? (class$org$apache$avalon$phoenix$components$kernel$DefaultKernel = DefaultKernel.class$("org.apache.avalon.phoenix.components.kernel.DefaultKernel")) : class$org$apache$avalon$phoenix$components$kernel$DefaultKernel));
    private static final Class[] APPLICATION_INTERFACES = new Class[]{class$org$apache$avalon$phoenix$interfaces$ApplicationMBean == null ? (class$org$apache$avalon$phoenix$interfaces$ApplicationMBean = DefaultKernel.class$("org.apache.avalon.phoenix.interfaces.ApplicationMBean")) : class$org$apache$avalon$phoenix$interfaces$ApplicationMBean};
    private SystemManager m_systemManager;
    private SystemManager m_applicationManager;
    private ConfigurationRepository m_repository;
    private ConfigurationValidator m_validator;
    private InstrumentManager m_instrumentManager;
    private final HashMap m_entries = new HashMap();
    private boolean m_addInvalidApplications;
    private int m_lockCount;
    private String[] m_lockedApplications;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$kernel$DefaultKernel;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$interfaces$ApplicationMBean;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_systemManager = (SystemManager)serviceManager.lookup(SystemManager.ROLE);
        this.m_repository = (ConfigurationRepository)serviceManager.lookup(ConfigurationRepository.ROLE);
        this.m_validator = (ConfigurationValidator)serviceManager.lookup(ConfigurationValidator.ROLE);
        this.m_instrumentManager = (InstrumentManager)serviceManager.lookup(InstrumentManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_addInvalidApplications = configuration.getChild("add-invalid-applications").getValueAsBoolean(false);
    }

    public void initialize() throws Exception {
        this.m_applicationManager = this.m_systemManager.getSubContext(null, "application");
    }

    public void dispose() {
        String[] names = this.getApplicationNames();
        for (int i = 0; i < names.length; ++i) {
            try {
                SarEntry entry = (SarEntry)this.m_entries.get(names[i]);
                this.shutdown(entry);
                continue;
            }
            catch (Exception e) {
                String message = REZ.getString("kernel.error.entry.dispose", (Object)names[i]);
                this.getLogger().warn(message, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        DefaultKernel defaultKernel = this;
        synchronized (defaultKernel) {
            this.m_lockedApplications = this.getApplicationNames();
            ++this.m_lockCount;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Kernel locked [count:" + this.m_lockCount + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        DefaultKernel defaultKernel = this;
        synchronized (defaultKernel) {
            --this.m_lockCount;
            if (this.m_lockCount < 0) {
                throw new IllegalStateException(REZ.getString("kernel.error.negativelock"));
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Kernel unlocked [count:" + this.m_lockCount + "]");
            }
        }
    }

    public String[] getApplicationNames() {
        if (this.isLocked()) {
            return this.m_lockedApplications;
        }
        return this.m_entries.keySet().toArray(new String[0]);
    }

    private boolean isLocked() {
        return this.m_lockCount > 0;
    }

    public Application getApplication(String name) {
        SarEntry entry = (SarEntry)this.m_entries.get(name);
        if (null == entry) {
            return null;
        }
        return entry.getApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startup(SarEntry entry) throws Exception {
        SarEntry sarEntry = entry;
        synchronized (sarEntry) {
            String name = entry.getProfile().getMetaData().getName();
            Application application = entry.getApplication();
            if (null == application) {
                String message;
                try {
                    DefaultApplication newApp = new DefaultApplication();
                    Logger childLogger = this.getLogger().getChildLogger(name);
                    ContainerUtil.enableLogging((Object)newApp, (Logger)childLogger);
                    ApplicationContext context = this.createApplicationContext(entry);
                    newApp.setApplicationContext(context);
                    ContainerUtil.initialize((Object)newApp);
                    application = newApp;
                }
                catch (Throwable t) {
                    entry.setApplication(null);
                    String message2 = REZ.getString("kernel.error.entry.initialize", (Object)entry.getProfile().getMetaData().getName());
                    throw new CascadingException(message2, t);
                }
                try {
                    ContainerUtil.start((Object)application);
                }
                catch (Throwable t) {
                    message = REZ.getString("kernel.error.entry.start", (Object)entry.getProfile().getMetaData().getName());
                    if (this.m_addInvalidApplications) {
                        this.getLogger().warn(message, t);
                    }
                    entry.setApplication(null);
                    throw new CascadingException(message, t);
                }
                entry.setApplication(application);
                try {
                    this.m_applicationManager.register(name, application, APPLICATION_INTERFACES);
                }
                catch (Throwable t) {
                    message = REZ.getString("kernel.error.entry.manage", (Object)name);
                    throw new CascadingException(message, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(SarEntry entry) throws Exception {
        SarEntry sarEntry = entry;
        synchronized (sarEntry) {
            Application application = entry.getApplication();
            if (null != application) {
                entry.setApplication(null);
                ContainerUtil.shutdown((Object)application);
            } else {
                String message = REZ.getString("kernel.error.entry.nostop", (Object)entry.getProfile().getMetaData().getName());
                this.getLogger().warn(message);
            }
        }
    }

    public void addApplication(PartitionProfile profile, File homeDirectory, File workDirectory, ClassLoader classLoader, LoggerStore store, Map classloaders) throws Exception {
        String name = profile.getMetaData().getName();
        SarEntry entry = new SarEntry(profile, homeDirectory, workDirectory, classLoader, store, classloaders);
        this.m_entries.put(name, entry);
        try {
            this.startup(entry);
        }
        catch (Exception e) {
            String message = REZ.getString("kernel.error.entry.start", (Object)name);
            this.getLogger().warn(message, (Throwable)e);
            throw e;
        }
    }

    private ApplicationContext createApplicationContext(SarEntry entry) throws Exception {
        String name = entry.getProfile().getMetaData().getName();
        DefaultApplicationContext context = new DefaultApplicationContext(entry.getProfile(), entry.getHomeDirectory(), entry.getWorkDirectory(), entry.getClassLoader(), entry.getLoggerStore(), entry.getClassLoaders());
        ContainerUtil.enableLogging((Object)context, (Logger)this.createContextLogger(name));
        ContainerUtil.service((Object)context, (ServiceManager)this.createServiceManager());
        ContainerUtil.initialize((Object)context);
        return context;
    }

    private Logger createContextLogger(String name) {
        String loggerName = name + ".frame";
        Logger childLogger = this.getLogger().getChildLogger(loggerName);
        return childLogger;
    }

    private ServiceManager createServiceManager() {
        DefaultServiceManager serviceManager = new DefaultServiceManager();
        serviceManager.put(SystemManager.ROLE, (Object)this.m_systemManager);
        serviceManager.put(ConfigurationRepository.ROLE, (Object)this.m_repository);
        serviceManager.put(ConfigurationValidator.ROLE, (Object)this.m_validator);
        serviceManager.put(InstrumentManager.ROLE, (Object)this.m_instrumentManager);
        serviceManager.put(Kernel.ROLE, (Object)this);
        serviceManager.makeReadOnly();
        return serviceManager;
    }

    public void removeApplication(String name) throws Exception {
        SarEntry entry = (SarEntry)this.m_entries.remove(name);
        if (null == entry) {
            String message = REZ.getString("kernel.error.entry.initialize", (Object)name);
            throw new Exception(message);
        }
        try {
            this.m_applicationManager.unregister(name);
        }
        catch (Throwable t) {
            String message = REZ.getString("kernel.error.entry.unmanage", (Object)name);
            throw new CascadingException(message, t);
        }
        this.shutdown(entry);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

