/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.components.manager.ManagedEntry;
import org.apache.avalon.phoenix.components.manager.SubContext;
import org.apache.avalon.phoenix.interfaces.ManagerException;
import org.apache.avalon.phoenix.interfaces.SystemManager;

public abstract class AbstractSystemManager
extends AbstractLogEnabled
implements SystemManager,
Initializable,
Disposable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$manager$AbstractSystemManager == null ? (class$org$apache$avalon$phoenix$components$manager$AbstractSystemManager = AbstractSystemManager.class$("org.apache.avalon.phoenix.components.manager.AbstractSystemManager")) : class$org$apache$avalon$phoenix$components$manager$AbstractSystemManager));
    private final Map m_entries = new HashMap();
    private SubContext m_subContext;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$manager$AbstractSystemManager;

    public void initialize() throws Exception {
        this.m_subContext = new SubContext(this, null, null);
    }

    public void dispose() {
        this.m_subContext = null;
    }

    public synchronized void register(String name, Object object, Class[] interfaces) throws ManagerException, IllegalArgumentException {
        if (null == interfaces) {
            String message = REZ.getString("manager.error.interfaces.null", (Object)name);
            throw new IllegalArgumentException(message);
        }
        this.verifyInterfaces(object, interfaces);
        this.doRegister(name, object, interfaces);
    }

    public synchronized void register(String name, Object object) throws ManagerException, IllegalArgumentException {
        this.doRegister(name, object, null);
    }

    public synchronized void unregister(String name) throws ManagerException {
        ManagedEntry entry = (ManagedEntry)this.m_entries.remove(name);
        if (null == entry) {
            String message = REZ.getString("manager.error.unregister.noentry", (Object)name);
            throw new ManagerException(message);
        }
        this.unexport(name, entry.getExportedObject());
    }

    public SystemManager getSubContext(String parent, String type) throws ManagerException {
        return this.m_subContext.getSubContext(parent, type);
    }

    protected abstract Object export(String var1, Object var2, Class[] var3) throws ManagerException;

    protected abstract void unexport(String var1, Object var2) throws ManagerException;

    protected void verifyName(String name, Object object) throws ManagerException {
    }

    protected abstract void verifyInterface(Class var1) throws ManagerException;

    private void verifyInterfaces(Object object, Class[] interfaces) throws ManagerException {
        for (int i = 0; i < interfaces.length; ++i) {
            Class clazz = interfaces[i];
            if (!clazz.isInterface()) {
                String message = REZ.getString("manager.error.verify.notinterface", (Object)clazz.getName());
                throw new ManagerException(message);
            }
            if (!clazz.isInstance(object)) {
                String message = REZ.getString("manager.error.verify.notinstance", (Object)clazz.getName());
                throw new ManagerException(message);
            }
            this.verifyInterface(clazz);
        }
    }

    private void checkRegister(String name, Object object) throws ManagerException, IllegalArgumentException {
        if (null == object) {
            throw new NullPointerException("object");
        }
        if (null == name) {
            throw new NullPointerException("name");
        }
        this.verifyName(name, object);
        if (null != this.m_entries.get(name)) {
            String message = REZ.getString("manager.error.register.exists", (Object)name);
            throw new ManagerException(message);
        }
    }

    private void doRegister(String name, Object object, Class[] interfaces) throws ManagerException {
        this.checkRegister(name, object);
        Object exportedObject = this.export(name, object, interfaces);
        ManagedEntry entry = new ManagedEntry(object, interfaces, exportedObject);
        this.m_entries.put(name, entry);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

