/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.manager;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class MBeanScripter {
    private final MBeanServer m_mBeanServer;
    private final Configuration m_configuration;
    private final ObjectName m_objectName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;

    public MBeanScripter(MBeanServer mBeanServer, Configuration configuration) throws ConfigurationException, MalformedObjectNameException {
        this.m_mBeanServer = mBeanServer;
        this.m_configuration = configuration;
        this.m_objectName = new ObjectName(this.m_configuration.getAttribute("name"));
    }

    public String getName() {
        return this.m_objectName.getCanonicalName();
    }

    public ObjectName getObjectName() {
        return this.m_objectName;
    }

    public void startup() throws Exception {
        this.m_mBeanServer.createMBean(this.m_configuration.getAttribute("class"), this.getObjectName(), null);
        this.setAttributes();
        this.setUses();
        this.invokeStartupOperations();
    }

    public void shutdown() throws Exception {
        this.invokeShutdownOperations();
    }

    private void setAttributes() throws Exception {
        Configuration[] attributes = this.m_configuration.getChildren("attribute");
        for (int i = 0; i < attributes.length; ++i) {
            this.setAttribute(attributes[i]);
        }
    }

    private void setAttribute(Configuration attribute) throws Exception {
        String name = attribute.getAttribute("name");
        String type = attribute.getAttribute("type");
        String rawValue = attribute.getValue(null);
        Object value = null;
        if (null != rawValue) {
            Class<?> valueClass = Class.forName(type);
            value = this.convertToObject(valueClass, rawValue);
        }
        this.m_mBeanServer.setAttribute(this.getObjectName(), new Attribute(name, value));
    }

    private void setUses() throws Exception {
        Configuration[] uses = this.m_configuration.getChildren("use");
        for (int i = 0; i < uses.length; ++i) {
            this.setUse(uses[i]);
        }
    }

    private void setUse(Configuration use) throws Exception {
        String name = use.getAttribute("name");
        String value = use.getValue();
        Attribute ref = new Attribute(name, new ObjectName(value));
        this.m_mBeanServer.setAttribute(this.getObjectName(), ref);
    }

    private void invokeStartupOperations() throws Exception {
        Configuration[] invokes = this.m_configuration.getChild("startup", true).getChildren("invoke");
        this.invokeOperations(invokes);
    }

    private void invokeShutdownOperations() throws Exception {
        Configuration[] invokes = this.m_configuration.getChild("startup", true).getChildren("invoke");
        this.invokeOperations(invokes);
    }

    private void invokeOperations(Configuration[] invokes) throws Exception {
        for (int i = 0; i < invokes.length; ++i) {
            Configuration invoke = invokes[i];
            this.invokeOperation(invoke);
        }
    }

    private void invokeOperation(Configuration invoke) throws Exception {
        String operationName = invoke.getAttribute("name");
        Configuration[] paramConfs = invoke.getChildren("parameter");
        String[] types = new String[paramConfs.length];
        Object[] values = new Object[paramConfs.length];
        for (int i = 0; i < paramConfs.length; ++i) {
            String type = paramConfs[i].getAttribute("type");
            String rawValue = paramConfs[i].getValue(null);
            Object value = null;
            if (null != rawValue) {
                Class<?> valueClass = Class.forName(type);
                value = this.convertToObject(valueClass, rawValue);
            }
            types[i] = type;
            values[i] = value;
        }
        this.m_mBeanServer.invoke(this.getObjectName(), operationName, values, types);
    }

    private Object convertToObject(Class valueClass, String s) {
        Object value = null;
        if (valueClass.equals(class$java$lang$String == null ? (class$java$lang$String = MBeanScripter.class$("java.lang.String")) : class$java$lang$String)) {
            value = s;
        } else if (valueClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = MBeanScripter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            value = new Byte(Byte.parseByte(s));
        } else if (valueClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = MBeanScripter.class$("java.lang.Short")) : class$java$lang$Short)) {
            value = new Short(Short.parseShort(s));
        } else if (valueClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = MBeanScripter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            value = new Integer(Integer.parseInt(s));
        } else if (valueClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = MBeanScripter.class$("java.lang.Long")) : class$java$lang$Long)) {
            value = new Long(Long.parseLong(s));
        } else if (valueClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = MBeanScripter.class$("java.lang.Float")) : class$java$lang$Float)) {
            value = new Float(Float.parseFloat(s));
        } else if (valueClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = MBeanScripter.class$("java.lang.Double")) : class$java$lang$Double)) {
            value = new Double(Double.parseDouble(s));
        } else if (valueClass.equals(class$java$lang$Character == null ? (class$java$lang$Character = MBeanScripter.class$("java.lang.Character")) : class$java$lang$Character)) {
            value = new Character(s.charAt(0));
        } else if (valueClass.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = MBeanScripter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            value = new Boolean(s);
        } else {
            throw new UnsupportedOperationException("can't yet convert " + valueClass);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

