/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.frontends;

import java.util.Vector;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.interfaces.SystemManager;

class CLISetup {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$frontends$CLISetup == null ? (class$org$apache$avalon$phoenix$frontends$CLISetup = CLISetup.class$("org.apache.avalon.phoenix.frontends.CLISetup")) : class$org$apache$avalon$phoenix$frontends$CLISetup));
    private static final String MANAGER_IMPL = "org.apache.avalon.phoenix.components.manager.DefaultManager";
    private static final int DEBUG_LOG_OPT = 100;
    private static final int HELP_OPT = 104;
    private static final int LOG_FILE_OPT = 108;
    private static final int APPS_PATH_OPT = 97;
    private static final int PERSISTENT_OPT = 112;
    private static final int CONFIGFILE_OPT = 102;
    private static final int REMOTE_MANAGER_OPT = 1;
    private static final int DISABLE_HOOK_OPT = 2;
    private static final int APPLICATION_OPT = 3;
    private final Parameters m_parameters = new Parameters();
    private final String m_command;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$frontends$CLISetup;

    public CLISetup(String command) {
        this.m_command = command;
    }

    private void usage(CLOptionDescriptor[] options) {
        System.err.println(this.m_command);
        System.err.println("\t" + REZ.getString("cli.desc.available.header"));
        System.err.println(CLUtil.describeOptions((CLOptionDescriptor[])options));
    }

    private CLOptionDescriptor[] createCLOptions() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, REZ.getString("cli.opt.help.desc")), new CLOptionDescriptor("log-file", 2, 108, REZ.getString("cli.opt.log-file.desc")), new CLOptionDescriptor("apps-path", 2, 97, REZ.getString("cli.opt.apps-path.desc")), new CLOptionDescriptor("debug-init", 8, 100, REZ.getString("cli.opt.debug-init.desc")), new CLOptionDescriptor("remote-manager", 8, 1, REZ.getString("cli.opt.remote-manager.desc")), new CLOptionDescriptor("disable-hook", 8, 2, REZ.getString("cli.opt.disable-hook.desc")), new CLOptionDescriptor("application", 2, 3, REZ.getString("cli.opt.application.desc")), new CLOptionDescriptor("persistent", 8, 112, REZ.getString("cli.opt.persistent.desc")), new CLOptionDescriptor("configfile", 2, 102, REZ.getString("cli.opt.configfile.desc"))};
        return options;
    }

    public Parameters getParameters() {
        return this.m_parameters;
    }

    public boolean parseCommandLineOptions(String[] args) {
        CLOptionDescriptor[] options = this.createCLOptions();
        CLArgsParser parser = new CLArgsParser(args, options);
        if (null != parser.getErrorString()) {
            String message = REZ.getString("cli.error.parser", (Object)parser.getErrorString());
            System.err.println(message);
            return false;
        }
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        block12: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)clOptions.get(i);
            switch (option.getDescriptor().getId()) {
                case 0: {
                    String message = REZ.getString("cli.error.unknown.arg", (Object)option.getArgument());
                    System.err.println(message);
                    return false;
                }
                case 104: {
                    this.usage(options);
                    return false;
                }
                case 100: {
                    this.m_parameters.setParameter("log-priority", "DEBUG");
                    continue block12;
                }
                case 108: {
                    this.m_parameters.setParameter("log-destination", option.getArgument());
                    continue block12;
                }
                case 97: {
                    this.m_parameters.setParameter("phoenix.apps.dir", option.getArgument());
                    continue block12;
                }
                case 1: {
                    this.m_parameters.setParameter(SystemManager.ROLE, MANAGER_IMPL);
                    continue block12;
                }
                case 3: {
                    this.m_parameters.setParameter("application-location", option.getArgument());
                    continue block12;
                }
                case 112: {
                    this.m_parameters.setParameter("persistent", "true");
                    continue block12;
                }
                case 2: {
                    this.m_parameters.setParameter("disable-hook", "true");
                    continue block12;
                }
                case 102: {
                    this.m_parameters.setParameter("phoenix.configfile", option.getArgument());
                }
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

