/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredBeanPropertyWriter {
    public static BeanPropertyWriter constructViewBased(BeanPropertyWriter base, Class<?>[] viewsToIncludeIn) {
        if (viewsToIncludeIn.length == 1) {
            return new SingleView(base, viewsToIncludeIn[0]);
        }
        return new MultiView(base, viewsToIncludeIn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MultiView
    extends BeanPropertyWriter {
        protected final Class<?>[] _views;

        protected MultiView(BeanPropertyWriter base, Class<?>[] views) {
            super(base);
            this._views = views;
        }

        protected MultiView(MultiView fromView, JsonSerializer<Object> ser) {
            super(fromView, ser);
            this._views = fromView._views;
        }

        @Override
        public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
            return new MultiView(this, ser);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Class<?> activeView = prov.getSerializationView();
            if (activeView != null) {
                int i;
                int len = this._views.length;
                for (i = 0; i < len && !this._views[i].isAssignableFrom(activeView); ++i) {
                }
                if (i == len) {
                    return;
                }
            }
            super.serializeAsField(bean, jgen, prov);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingleView
    extends BeanPropertyWriter {
        protected final Class<?> _view;

        protected SingleView(BeanPropertyWriter base, Class<?> view) {
            super(base);
            this._view = view;
        }

        protected SingleView(SingleView fromView, JsonSerializer<Object> ser) {
            super(fromView, ser);
            this._view = fromView._view;
        }

        @Override
        public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
            return new SingleView(this, ser);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Class<?> activeView = prov.getSerializationView();
            if (activeView == null || this._view.isAssignableFrom(activeView)) {
                super.serializeAsField(bean, jgen, prov);
            }
        }
    }
}

