/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.containerkit.lifecycle.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.DefaultComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.DefaultServiceManager;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.phoenix.containerkit.factory.ComponentBundle;
import org.apache.avalon.phoenix.containerkit.factory.ComponentFactory;
import org.apache.avalon.phoenix.containerkit.lifecycle.ResourceProvider;
import org.apache.avalon.phoenix.containerkit.metadata.ComponentMetaData;
import org.apache.avalon.phoenix.containerkit.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.ContextDescriptor;
import org.apache.avalon.phoenix.framework.info.EntryDescriptor;

public abstract class AbstractResourceProvider
extends AbstractLogEnabled
implements ResourceProvider {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$containerkit$lifecycle$impl$AbstractResourceProvider == null ? (class$org$apache$avalon$phoenix$containerkit$lifecycle$impl$AbstractResourceProvider = AbstractResourceProvider.class$("org.apache.avalon.phoenix.containerkit.lifecycle.impl.AbstractResourceProvider")) : class$org$apache$avalon$phoenix$containerkit$lifecycle$impl$AbstractResourceProvider));
    private final ComponentFactory m_factory;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$containerkit$lifecycle$impl$AbstractResourceProvider;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Component;

    protected AbstractResourceProvider(ComponentFactory factory) {
        if (null == factory) {
            throw new NullPointerException("factory");
        }
        this.m_factory = factory;
    }

    protected abstract Object getService(String var1, Object var2);

    protected abstract Object getContextValue(String var1, Object var2);

    public Object createObject(Object entry) throws Exception {
        ComponentMetaData component = this.getMetaData(entry);
        String implementationKey = component.getImplementationKey();
        return this.m_factory.createComponent(implementationKey);
    }

    public Parameters createParameters(Object entry) throws Exception {
        ComponentMetaData component = this.getMetaData(entry);
        Parameters parameters = component.getParameters();
        if (null == parameters) {
            String message = REZ.getString("resource.missing-parameters.error", (Object)component.getName());
            throw new Exception(message);
        }
        parameters.makeReadOnly();
        return parameters;
    }

    public Configuration createConfiguration(Object entry) throws Exception {
        ComponentMetaData component = this.getMetaData(entry);
        Configuration configuration = component.getConfiguration();
        if (null == configuration) {
            String message = REZ.getString("resource.missing-configuration.error", (Object)component.getName());
            throw new Exception(message);
        }
        return configuration;
    }

    protected Context createContextImpl(Map contextData) {
        DefaultContext context = new DefaultContext(contextData);
        context.makeReadOnly();
        return context;
    }

    protected ComponentMetaData getMetaData(Object entry) {
        return (ComponentMetaData)entry;
    }

    public final Context createContext(Object componentEntry) throws Exception {
        String classname;
        ComponentMetaData component = this.getMetaData(componentEntry);
        String componentName = component.getName();
        String impl = component.getImplementationKey();
        ComponentBundle bundle = this.m_factory.createBundle(impl);
        ComponentInfo info = bundle.getComponentInfo();
        ContextDescriptor descriptor = info.getContext();
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        EntryDescriptor[] entrys = descriptor.getEntrys();
        for (int i = 0; i < entrys.length; ++i) {
            EntryDescriptor entry = entrys[i];
            String key = entry.getKey();
            String type = entry.getType();
            boolean optional = entry.isOptional();
            Object value = this.getContextValue(key, componentEntry);
            if (null == value) {
                String message = REZ.getString("resource.missing-context-value.error", (Object)(optional ? "1" : "2"), (Object)key, (Object)componentName);
                if (!optional) {
                    throw new Exception(message);
                }
                this.getLogger().warn(message);
                continue;
            }
            boolean typeValid = this.objectImplementsType(value, type);
            if (!typeValid) {
                String message = REZ.getString("resource.bad-value-type.error", (Object)(optional ? "1" : "2"), (Object)key, (Object)componentName, (Object)type, (Object)value.getClass().getName());
                if (!optional) {
                    throw new Exception(message);
                }
                this.getLogger().warn(message);
                continue;
            }
            contextData.put(key, value);
        }
        Context context = this.createContextImpl(contextData);
        boolean validContextClass = this.objectImplementsType(context, classname = descriptor.getType());
        if (!validContextClass) {
            String message = REZ.getString("resource.bad-context-type.error", (Object)classname, (Object)context.getClass().getName(), (Object)componentName);
            throw new Exception(message);
        }
        return context;
    }

    public final ComponentManager createComponentManager(Object entry) throws Exception {
        Map services = this.createServiceMap(entry);
        DefaultComponentManager componentManager = new DefaultComponentManager();
        Iterator keys = services.keySet().iterator();
        while (keys.hasNext()) {
            String key;
            Object service;
            if (!(class$org$apache$avalon$framework$component$Component == null ? AbstractResourceProvider.class$("org.apache.avalon.framework.component.Component") : class$org$apache$avalon$framework$component$Component).isInstance(service = services.get(key = (String)keys.next()))) {
                String message = REZ.getString("resource.service-not-a-component.error", (Object)key, (Object)service.getClass().getName());
                throw new Exception(message);
            }
            componentManager.put(key, (Component)service);
        }
        componentManager.makeReadOnly();
        return componentManager;
    }

    public final ServiceManager createServiceManager(Object entry) throws Exception {
        Map services = this.createServiceMap(entry);
        DefaultServiceManager serviceManager = new DefaultServiceManager();
        Iterator keys = services.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object service = services.get(key);
            serviceManager.put(key, service);
        }
        serviceManager.makeReadOnly();
        return serviceManager;
    }

    protected final ComponentFactory getComponentFactory() {
        return this.m_factory;
    }

    private Map createServiceMap(Object componentEntry) throws Exception {
        ComponentMetaData component = this.getMetaData(componentEntry);
        String impl = component.getImplementationKey();
        ComponentBundle bundle = this.m_factory.createBundle(impl);
        ComponentInfo info = bundle.getComponentInfo();
        DependencyMetaData[] dependencies = component.getDependencies();
        HashMap<String, Object> services = new HashMap<String, Object>();
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyMetaData dependency = dependencies[i];
            String key = dependency.getKey();
            String providerName = dependency.getProviderName();
            boolean optional = info.getDependency(key).isOptional();
            Object service = this.getService(providerName, componentEntry);
            if (null == service) {
                String message = REZ.getString("resource.missing-dependency.error", (Object)(optional ? "1" : "2"), (Object)key, (Object)component.getName());
                if (!optional) {
                    throw new Exception(message);
                }
                this.getLogger().warn(message);
                continue;
            }
            services.put(key, service);
        }
        return services;
    }

    private boolean objectImplementsType(Object value, String type) {
        try {
            Class<?> clazz = value.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Class<?> typeClass = classLoader.loadClass(type);
            if (typeClass.isAssignableFrom(clazz)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

