/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.infobuilder;

import java.io.InputStream;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.tools.infobuilder.InfoReader;
import org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyBlockInfoReader;
import org.apache.avalon.phoenix.framework.tools.infobuilder.SerializedInfoReader;
import org.apache.avalon.phoenix.framework.tools.infobuilder.XMLInfoReader;

public final class InfoBuilder
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$framework$tools$infobuilder$InfoBuilder == null ? (class$org$apache$avalon$phoenix$framework$tools$infobuilder$InfoBuilder = InfoBuilder.class$("org.apache.avalon.phoenix.framework.tools.infobuilder.InfoBuilder")) : class$org$apache$avalon$phoenix$framework$tools$infobuilder$InfoBuilder));
    private final InfoReader m_xmlInfoCreator = InfoBuilder.createXMLInfoCreator();
    private final InfoReader m_serialInfoCreator = new SerializedInfoReader();
    private final InfoReader m_legacyInfoCreator = InfoBuilder.createLegacyInfoCreator();
    static /* synthetic */ Class class$org$apache$avalon$phoenix$framework$tools$infobuilder$InfoBuilder;

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.setupLogger(this.m_serialInfoCreator);
        if (null != this.m_xmlInfoCreator) {
            this.setupLogger(this.m_xmlInfoCreator);
        }
        if (null != this.m_legacyInfoCreator) {
            this.setupLogger(this.m_legacyInfoCreator);
        }
        if (null != this.m_legacyInfoCreator) {
            this.setupLogger(this.m_legacyInfoCreator);
        }
    }

    public ComponentInfo buildComponentInfo(Class clazz) throws Exception {
        return this.buildComponentInfo(clazz.getName(), clazz.getClassLoader());
    }

    public ComponentInfo buildComponentInfo(String classname, ClassLoader classLoader) throws Exception {
        ComponentInfo info = this.buildComponentFromSer(classname, classLoader);
        if (null != info) {
            return info;
        }
        info = this.buildComponentFromLegacy(classname, classLoader);
        if (null != info) {
            return info;
        }
        return this.buildComponentFromXML(classname, classLoader);
    }

    private ComponentInfo buildComponentFromSer(String classname, ClassLoader classLoader) throws Exception {
        String xinfo = this.deriveResourceName(classname, "-info.ser");
        InputStream inputStream = classLoader.getResourceAsStream(xinfo);
        if (null == inputStream) {
            return null;
        }
        return this.m_serialInfoCreator.createComponentInfo(classname, inputStream);
    }

    private ComponentInfo buildComponentFromLegacy(String classname, ClassLoader classLoader) throws Exception {
        String xinfo = this.deriveResourceName(classname, ".xinfo");
        InputStream inputStream = classLoader.getResourceAsStream(xinfo);
        if (null == inputStream) {
            return null;
        }
        if (null != this.m_legacyInfoCreator) {
            return this.m_legacyInfoCreator.createComponentInfo(classname, inputStream);
        }
        return null;
    }

    private ComponentInfo buildComponentFromXML(String classname, ClassLoader classLoader) throws Exception {
        String xinfo = this.deriveResourceName(classname, "-info.xml");
        InputStream inputStream = classLoader.getResourceAsStream(xinfo);
        if (null == inputStream) {
            String message = REZ.getString("builder.missing-info.error", (Object)classname);
            throw new Exception(message);
        }
        InfoReader xmlInfoCreator = this.getXMLInfoCreator(classname);
        return xmlInfoCreator.createComponentInfo(classname, inputStream);
    }

    private InfoReader getXMLInfoCreator(String classname) throws Exception {
        if (null != this.m_xmlInfoCreator) {
            return this.m_xmlInfoCreator;
        }
        String message = REZ.getString("builder.missing-xml-creator.error", (Object)classname);
        throw new Exception(message);
    }

    private static InfoReader createXMLInfoCreator() {
        try {
            return new XMLInfoReader();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static InfoReader createLegacyInfoCreator() {
        try {
            return new LegacyBlockInfoReader();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String deriveResourceName(String classname, String postfix) {
        return classname.replace('.', '/') + postfix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

