/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.infobuilder;

import java.util.Properties;
import org.apache.avalon.framework.Version;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.ComponentDescriptor;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.ContextDescriptor;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.EntryDescriptor;
import org.apache.avalon.phoenix.framework.info.FeatureDescriptor;
import org.apache.avalon.phoenix.framework.info.LoggerDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;

public class LegacyUtil {
    public static final String MX_ATTRIBUTE_NAME = "phoenix:mx";
    public static final Attribute MX_ATTRIBUTE = new Attribute("phoenix:mx", null);
    public static final String VERSION_ATTRIBUTE_NAME = "phoenix:version";
    public static final String VERSION_ATTRIBUTE_PARAMETER = "version";
    public static final ContextDescriptor CONTEXT_DESCRIPTOR = new ContextDescriptor("org.apache.avalon.phoenix.BlockContext", EntryDescriptor.EMPTY_SET, Attribute.EMPTY_SET);

    private LegacyUtil() {
    }

    public static String translateToSchemaUri(String type) {
        if (type.equals("relax-ng")) {
            return "http://relaxng.org/ns/structure/1.0";
        }
        return type;
    }

    public static String getVersionString(FeatureDescriptor feature) {
        Attribute tag = feature.getAttribute("avalon");
        if (null != tag) {
            return tag.getParameter(VERSION_ATTRIBUTE_PARAMETER);
        }
        return null;
    }

    public static Attribute createVersionAttribute(String version) {
        Properties parameters = new Properties();
        parameters.setProperty(VERSION_ATTRIBUTE_PARAMETER, version);
        return new Attribute(VERSION_ATTRIBUTE_NAME, parameters);
    }

    public static boolean isMxService(ServiceDescriptor service) {
        Attribute tag = service.getAttribute(MX_ATTRIBUTE_NAME);
        return null != tag;
    }

    public static Version toVersion(FeatureDescriptor feature) {
        String version = LegacyUtil.getVersionString(feature);
        if (null == version) {
            return new Version(1, 0, 0);
        }
        return Version.getVersion((String)version);
    }

    public static ComponentInfo createListenerInfo(String implementationKey) {
        ComponentDescriptor descriptor = new ComponentDescriptor(implementationKey, Attribute.EMPTY_SET);
        return new ComponentInfo(descriptor, ServiceDescriptor.EMPTY_SET, LoggerDescriptor.EMPTY_SET, ContextDescriptor.EMPTY_CONTEXT, DependencyDescriptor.EMPTY_SET, null, null);
    }

    public static String getSchemaLocationFor(String classname) {
        int index = classname.lastIndexOf(".");
        String location = classname;
        if (-1 != index) {
            location = classname.substring(index + 1);
        }
        location = location + "-schema.xml";
        return location;
    }
}

