/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.infobuilder;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.ComponentDescriptor;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.ContextDescriptor;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.EntryDescriptor;
import org.apache.avalon.phoenix.framework.info.LoggerDescriptor;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.infobuilder.InfoReader;
import org.apache.avalon.phoenix.tools.configuration.ConfigurationBuilder;
import org.xml.sax.InputSource;

public final class XMLInfoReader
extends AbstractLogEnabled
implements InfoReader {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$framework$tools$infobuilder$XMLInfoReader == null ? (class$org$apache$avalon$phoenix$framework$tools$infobuilder$XMLInfoReader = XMLInfoReader.class$("org.apache.avalon.phoenix.framework.tools.infobuilder.XMLInfoReader")) : class$org$apache$avalon$phoenix$framework$tools$infobuilder$XMLInfoReader));
    static /* synthetic */ Class class$org$apache$avalon$phoenix$framework$tools$infobuilder$XMLInfoReader;

    public ComponentInfo createComponentInfo(String implementationKey, InputStream inputStream) throws Exception {
        InputSource input = new InputSource(inputStream);
        Configuration configuration = ConfigurationBuilder.build(input, "-//AVALON/Component Info DTD Version 1.0//EN", this.getLogger());
        return this.buildComponentInfo(implementationKey, configuration);
    }

    private ComponentInfo buildComponentInfo(String classname, Configuration info) throws Exception {
        String topLevelName;
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("builder.creating-info.notice", (Object)classname);
            this.getLogger().debug(message);
        }
        if (!(topLevelName = info.getName()).equals("component-info")) {
            String message = REZ.getString("builder.bad-toplevel-element.error", (Object)classname, (Object)topLevelName);
            throw new ConfigurationException(message);
        }
        Configuration configuration = null;
        configuration = info.getChild("component");
        ComponentDescriptor descriptor = this.buildComponentDescriptor(configuration);
        String implementationKey = descriptor.getImplementationKey();
        configuration = info.getChild("loggers");
        LoggerDescriptor[] loggers = this.buildLoggers(configuration);
        configuration = info.getChild("context");
        ContextDescriptor context = this.buildContext(configuration);
        configuration = info.getChild("services");
        ServiceDescriptor[] services = this.buildServices(configuration);
        configuration = info.getChild("dependencies");
        DependencyDescriptor[] dependencies = this.buildDependencies(implementationKey, configuration);
        configuration = info.getChild("configuration-schema", false);
        SchemaDescriptor configurationSchema = this.buildSchema(configuration);
        configuration = info.getChild("parameters-schema", false);
        SchemaDescriptor parametersSchema = this.buildSchema(configuration);
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("builder.created-info.notice", (Object)implementationKey, (Object)new Integer(services.length), (Object)new Integer(dependencies.length), (Object)new Integer(context.getEntrys().length), (Object)new Integer(loggers.length));
            this.getLogger().debug(message);
        }
        return new ComponentInfo(descriptor, services, loggers, context, dependencies, configurationSchema, parametersSchema);
    }

    private SchemaDescriptor buildSchema(Configuration configuration) throws ConfigurationException {
        if (null == configuration) {
            return null;
        }
        String location = configuration.getAttribute("location", "");
        String type = configuration.getAttribute("type", "");
        Attribute[] attributes = this.buildAttributes(configuration);
        return new SchemaDescriptor(location, type, attributes);
    }

    private LoggerDescriptor[] buildLoggers(Configuration configuration) throws ConfigurationException {
        Configuration[] elements = configuration.getChildren("logger");
        ArrayList<LoggerDescriptor> loggers = new ArrayList<LoggerDescriptor>();
        for (int i = 0; i < elements.length; ++i) {
            LoggerDescriptor logger = this.buildLogger(elements[i]);
            loggers.add(logger);
        }
        return loggers.toArray(new LoggerDescriptor[loggers.size()]);
    }

    private LoggerDescriptor buildLogger(Configuration logger) throws ConfigurationException {
        String name = logger.getAttribute("name", "");
        Attribute[] attributes = this.buildAttributes(logger);
        return new LoggerDescriptor(name, attributes);
    }

    private DependencyDescriptor[] buildDependencies(String classname, Configuration configuration) throws ConfigurationException {
        Configuration[] elements = configuration.getChildren("dependency");
        ArrayList<DependencyDescriptor> dependencies = new ArrayList<DependencyDescriptor>();
        for (int i = 0; i < elements.length; ++i) {
            DependencyDescriptor dependency = this.buildDependency(classname, elements[i]);
            dependencies.add(dependency);
        }
        return dependencies.toArray(DependencyDescriptor.EMPTY_SET);
    }

    private DependencyDescriptor buildDependency(String classname, Configuration dependency) throws ConfigurationException {
        String implementationKey = dependency.getAttribute("type");
        boolean optional = dependency.getAttributeAsBoolean("optional", false);
        Attribute[] attributes = this.buildAttributes(dependency);
        String key = dependency.getAttribute("key", null);
        if (null == key) {
            key = implementationKey;
        } else if (key.equals(implementationKey)) {
            String message = REZ.getString("builder.redundent-key.notice", (Object)classname, (Object)key);
            this.getLogger().warn(message);
        }
        return new DependencyDescriptor(key, implementationKey, optional, attributes);
    }

    private ContextDescriptor buildContext(Configuration context) throws ConfigurationException {
        EntryDescriptor[] entrys = this.buildEntrys(context.getChildren("entry"));
        Attribute[] attributes = this.buildAttributes(context);
        String type = context.getAttribute("type", "org.apache.avalon.framework.context.Context");
        return new ContextDescriptor(type, entrys, attributes);
    }

    private EntryDescriptor[] buildEntrys(Configuration[] entrySet) throws ConfigurationException {
        ArrayList<EntryDescriptor> entrys = new ArrayList<EntryDescriptor>();
        for (int i = 0; i < entrySet.length; ++i) {
            EntryDescriptor service = this.buildEntry(entrySet[i]);
            entrys.add(service);
        }
        return entrys.toArray(new EntryDescriptor[entrys.size()]);
    }

    private EntryDescriptor buildEntry(Configuration config) throws ConfigurationException {
        String key = config.getAttribute("key");
        String type = config.getAttribute("type");
        boolean optional = config.getAttributeAsBoolean("optional", false);
        Attribute[] attributes = this.buildAttributes(config);
        return new EntryDescriptor(key, type, optional, attributes);
    }

    private ServiceDescriptor[] buildServices(Configuration servicesSet) throws ConfigurationException {
        Configuration[] elements = servicesSet.getChildren("service");
        ArrayList<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();
        for (int i = 0; i < elements.length; ++i) {
            ServiceDescriptor service = this.buildService(elements[i]);
            services.add(service);
        }
        return services.toArray(ServiceDescriptor.EMPTY_SET);
    }

    private ServiceDescriptor buildService(Configuration service) throws ConfigurationException {
        String type = service.getAttribute("type");
        Attribute[] attributes = this.buildAttributes(service);
        return new ServiceDescriptor(type, attributes);
    }

    private Attribute[] buildAttributes(Configuration config) throws ConfigurationException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Configuration[] attributeConfigs = config.getChildren("attribute");
        for (int i = 0; i < attributeConfigs.length; ++i) {
            Configuration attributeConfig = attributeConfigs[i];
            Attribute attribute = this.buildAttribute(attributeConfig);
            attributes.add(attribute);
        }
        return attributes.toArray(new Attribute[attributes.size()]);
    }

    private Attribute buildAttribute(Configuration config) throws ConfigurationException {
        String name = config.getAttribute("name");
        Properties parameters = this.buildParameters(config);
        if (0 == parameters.size()) {
            return new Attribute(name, null);
        }
        return new Attribute(name, parameters);
    }

    private Properties buildParameters(Configuration config) throws ConfigurationException {
        Properties parameters = new Properties();
        Configuration[] children = config.getChildren("param");
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String key = child.getAttribute("name");
            String value = child.getAttribute("value");
            parameters.setProperty(key, value);
        }
        return parameters;
    }

    private ComponentDescriptor buildComponentDescriptor(Configuration config) throws ConfigurationException {
        String type = config.getAttribute("type");
        Attribute[] attributes = this.buildAttributes(config);
        return new ComponentDescriptor(type, attributes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

