/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.verifier;

import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.containerkit.metadata.ComponentMetaData;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.containerkit.profile.PartitionProfile;
import org.apache.avalon.phoenix.containerkit.verifier.AssemblyVerifier;
import org.apache.avalon.phoenix.framework.tools.verifier.InfoVerifier;
import org.apache.avalon.phoenix.framework.tools.verifier.VerifyException;

public class SarVerifier
extends AssemblyVerifier {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$tools$verifier$SarVerifier == null ? (class$org$apache$avalon$phoenix$tools$verifier$SarVerifier = SarVerifier.class$("org.apache.avalon.phoenix.tools.verifier.SarVerifier")) : class$org$apache$avalon$phoenix$tools$verifier$SarVerifier));
    private static final Class BLOCK_CLASS = SarVerifier.getClass("org.apache.avalon.phoenix.Block");
    private static final Class BLOCKLISTENER_CLASS = SarVerifier.getClass("org.apache.avalon.phoenix.BlockListener");
    private final InfoVerifier m_infoVerifier = new InfoVerifier();
    static /* synthetic */ Class class$org$apache$avalon$phoenix$tools$verifier$SarVerifier;

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.m_infoVerifier.enableLogging(logger);
    }

    public void verifySar(PartitionProfile profile, ClassLoader classLoader) throws VerifyException {
        ComponentProfile[] blocks = profile.getPartition("block").getComponents();
        ComponentProfile[] listeners = profile.getPartition("listener").getComponents();
        String message = REZ.getString("verify-valid-names");
        this.getLogger().info(message);
        this.verifySarName(profile.getMetaData().getName());
        this.verifyValidNames(listeners);
        super.verifyAssembly(blocks);
        message = REZ.getString("verify-unique-names");
        this.getLogger().info(message);
        this.checkNamesUnique(blocks, listeners);
        message = REZ.getString("verify-block-type");
        this.getLogger().info(message);
        this.verifyBlocksType(blocks, classLoader);
        message = REZ.getString("verify-listener-type");
        this.getLogger().info(message);
        this.verifyListenersType(listeners, classLoader);
    }

    private void verifyBlocksType(ComponentProfile[] blocks, ClassLoader classLoader) throws VerifyException {
        for (int i = 0; i < blocks.length; ++i) {
            this.verifyBlockType(blocks[i], classLoader);
        }
    }

    private void verifyBlockType(ComponentProfile block, ClassLoader classLoader) throws VerifyException {
        ComponentMetaData metaData = block.getMetaData();
        Class clazz = this.loadClass("block", metaData, classLoader);
        this.m_infoVerifier.verifyType(metaData.getName(), metaData.getImplementationKey(), block.getInfo(), classLoader);
        if (BLOCK_CLASS.isAssignableFrom(clazz)) {
            String message = REZ.getString("verifier.implements-block.error", (Object)metaData.getName(), (Object)metaData.getImplementationKey());
            this.getLogger().error(message);
            System.err.println(message);
        }
    }

    private Class loadClass(String type, ComponentMetaData metaData, ClassLoader classLoader) throws VerifyException {
        try {
            return classLoader.loadClass(metaData.getImplementationKey());
        }
        catch (Exception e) {
            String message = REZ.getString("bad-" + type + "-class", (Object)metaData.getName(), (Object)metaData.getImplementationKey(), (Object)e.getMessage());
            throw new VerifyException(message);
        }
    }

    private void verifyListenersType(ComponentProfile[] listeners, ClassLoader classLoader) throws VerifyException {
        for (int i = 0; i < listeners.length; ++i) {
            this.verifyListenerType(listeners[i], classLoader);
        }
    }

    private void verifyListenerType(ComponentProfile listener, ClassLoader classLoader) throws VerifyException {
        ComponentMetaData metaData = listener.getMetaData();
        Class clazz = this.loadClass("listener", metaData, classLoader);
        if (!BLOCKLISTENER_CLASS.isAssignableFrom(clazz)) {
            String message = REZ.getString("listener-noimpl-listener", (Object)metaData, (Object)metaData);
            throw new VerifyException(message);
        }
    }

    private void verifySarName(String name) throws VerifyException {
        if (!this.isValidName(name)) {
            String message = REZ.getString("invalid-sar-name", (Object)name);
            throw new VerifyException(message);
        }
    }

    public boolean isValidName(String name) {
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || '-' == ch || '.' == ch) continue;
            return false;
        }
        return true;
    }

    private void checkNamesUnique(ComponentProfile[] blocks, ComponentProfile[] listeners) throws VerifyException {
        String name;
        int i;
        for (i = 0; i < blocks.length; ++i) {
            name = blocks[i].getMetaData().getName();
            this.checkNameUnique(name, blocks, listeners, i, -1);
        }
        for (i = 0; i < listeners.length; ++i) {
            name = listeners[i].getMetaData().getName();
            this.checkNameUnique(name, blocks, listeners, -1, i);
        }
    }

    private void checkNameUnique(String name, ComponentProfile[] blocks, ComponentProfile[] listeners, int blockIndex, int listenerIndex) throws VerifyException {
        String other;
        int i;
        for (i = 0; i < blocks.length; ++i) {
            other = blocks[i].getMetaData().getName();
            if (blockIndex == i || !name.equals(other)) continue;
            String message = REZ.getString("duplicate-name", (Object)name);
            throw new VerifyException(message);
        }
        for (i = 0; i < listeners.length; ++i) {
            other = listeners[i].getMetaData().getName();
            if (listenerIndex == i || !name.equals(other)) continue;
            String message = REZ.getString("duplicate-name", (Object)name);
            throw new VerifyException(message);
        }
    }

    private static Class getClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException cnfe) {
            String message = "Unable to lcoate class " + classname + " due to " + cnfe;
            throw new IllegalStateException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

