/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.mailet;

import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.jsieve.ConfigurationManager;
import org.apache.jsieve.SieveConfigurationException;
import org.apache.jsieve.SieveFactory;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mailet.ActionDispatcher;
import org.apache.jsieve.mailet.CommonsLoggingAdapter;
import org.apache.jsieve.mailet.Poster;
import org.apache.jsieve.mailet.ResourceLocator;
import org.apache.jsieve.mailet.SieveMailAdapter;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class SieveMailboxMailet
extends GenericMailet {
    private String deliveryHeader;
    private boolean resetReturnPath;
    private Poster poster;
    private ResourceLocator locator;
    private boolean verbose = false;
    private boolean consume = true;
    private boolean quiet = true;
    private SieveFactory factory;
    private ActionDispatcher actionDispatcher;
    private Log log;

    public SieveMailboxMailet() {
    }

    public SieveMailboxMailet(Poster poster, ResourceLocator locator) {
        this();
        this.poster = poster;
        this.locator = locator;
    }

    public ResourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    public Poster getPoster() {
        return this.poster;
    }

    public void setPoster(Poster poster) {
        this.poster = poster;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isInfoLoggingOn() {
        return this.verbose || !this.quiet;
    }

    public void init(MailetConfig config) throws MessagingException {
        super.init(config);
        try {
            ConfigurationManager configurationManager = new ConfigurationManager();
            int logLevel = this.verbose ? 6 : (this.quiet ? 1 : 3);
            this.log = new CommonsLoggingAdapter(this, logLevel);
            configurationManager.setLog(this.log);
            this.factory = configurationManager.build();
        }
        catch (SieveConfigurationException e) {
            throw new MessagingException("Failed to load standard Sieve configuration.", (Exception)((Object)e));
        }
    }

    public void service(Mail mail) throws MessagingException {
        Enumeration headers;
        Collection recipients = mail.getRecipients();
        Vector<MailAddress> errors = new Vector<MailAddress>();
        MimeMessage message = null;
        if (this.deliveryHeader != null || this.resetReturnPath) {
            message = mail.getMessage();
        }
        if (this.resetReturnPath) {
            message.setHeader("Return-Path", mail.getSender() == null ? "<>" : "<" + mail.getSender() + ">");
        }
        InternetHeaders deliveredTo = new InternetHeaders();
        if (this.deliveryHeader != null) {
            headers = message.getMatchingHeaders(new String[]{this.deliveryHeader});
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                deliveredTo.addHeader(header.getName(), header.getValue());
            }
        }
        Iterator i = recipients.iterator();
        while (i.hasNext()) {
            MailAddress recipient = (MailAddress)i.next();
            try {
                if (this.deliveryHeader != null) {
                    message.addHeader(this.deliveryHeader, recipient.toString());
                }
                this.storeMail(mail.getSender(), recipient, mail);
                if (this.deliveryHeader == null || !i.hasNext()) continue;
                message.removeHeader(this.deliveryHeader);
                headers = deliveredTo.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    message.addHeader(header.getName(), header.getValue());
                }
            }
            catch (Exception ex) {
                this.log("Error while storing mail.", ex);
                errors.add(recipient);
            }
        }
        if (!errors.isEmpty()) {
            this.getMailetContext().sendMail(mail.getSender(), errors, mail.getMessage(), "error");
        }
        if (this.consume) {
            mail.setState("ghost");
        }
    }

    public String getMailetInfo() {
        return "Sieve Mailbox Mailet";
    }

    public void storeMail(MailAddress sender, MailAddress recipient, Mail mail) throws MessagingException {
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient for mail to be spooled cannot be null.");
        }
        if (mail.getMessage() == null) {
            throw new IllegalArgumentException("Mail message to be spooled cannot be null.");
        }
        this.sieveMessage(recipient, mail);
    }

    void sieveMessage(MailAddress recpient, Mail aMail) throws MessagingException {
        String username = this.getUsername(recpient);
        String relativeUri = "//" + username + "/sieve";
        try {
            InputStream ins = this.locator.get(relativeUri);
            SieveMailAdapter aMailAdapter = new SieveMailAdapter(aMail, this.getMailetContext(), this.actionDispatcher, this.poster);
            aMailAdapter.setLog(this.log);
            if (this.verbose) {
                this.log("Evaluating " + aMailAdapter.toString() + "against \"" + relativeUri + "\"");
            }
            this.factory.evaluate((MailAdapter)aMailAdapter, this.factory.parse(ins));
        }
        catch (Exception ex) {
            if (this.isInfoLoggingOn()) {
                this.log("Cannot evaluate Sieve script. Storing mail in user INBOX.", ex);
            }
            this.storeMessageInbox(username, aMail);
        }
    }

    void storeMessageInbox(String username, Mail mail) throws MessagingException {
        String url = "mailbox://" + username + "/";
        this.poster.post(url, mail.getMessage());
    }

    public void init() throws MessagingException {
        super.init();
        if (this.poster == null || this.locator == null) {
            throw new MailetException("Not initialised. Please ensure that the mailet container supports either setter or constructor injection");
        }
        this.deliveryHeader = this.getInitParameter("addDeliveryHeader");
        this.resetReturnPath = this.getInitParameter("resetReturnPath", true);
        this.consume = this.getInitParameter("consume", true);
        this.verbose = this.getInitParameter("verbose", false);
        this.quiet = this.getInitParameter("quiet", false);
        this.actionDispatcher = new ActionDispatcher();
    }

    protected String getUsername(MailAddress m) {
        return m.getLocalPart() + "@localhost";
    }
}

