/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.management.MBeanServer;
import mx4j.adaptor.interceptor.AdaptorInterceptor;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.adaptor.interceptor.InvocationResult;
import mx4j.adaptor.rmi.UnmarshallingMBeanServer;
import mx4j.log.Logger;
import mx4j.util.MethodTernaryTree;
import mx4j.util.Utils;

public final class InvokerAdaptorInterceptor
extends AdaptorInterceptor {
    private MethodTernaryTree m_methods = new MethodTernaryTree();
    private MBeanServer m_unmarshaller;
    static /* synthetic */ Class class$javax$management$MBeanServer;

    public void setMBeanServer(MBeanServer server) {
        super.setMBeanServer(server);
        this.m_unmarshaller = new UnmarshallingMBeanServer(server);
    }

    public String getType() {
        return "invoker";
    }

    public void setEnabled(boolean value) {
    }

    public boolean isEnabled() {
        return true;
    }

    public InvocationResult invoke(Invocation invocation) throws Exception {
        return this.doInvoke(invocation);
    }

    protected InvocationResult doInvoke(Invocation invocation) throws Exception {
        Logger logger = this.getLogger();
        boolean debug = logger.isEnabledFor(10);
        if (debug) {
            logger.debug("Last interceptor, invoking MBeanServer");
        }
        String name = invocation.getMethodName();
        if (debug) {
            logger.debug("Method name is: " + name);
        }
        String[] signature = invocation.getSignature();
        Class[] params = Utils.loadClasses(Thread.currentThread().getContextClassLoader(), signature);
        if (debug) {
            logger.debug("Signature is: " + Arrays.asList(signature));
        }
        Object[] args = invocation.getArguments();
        if (debug) {
            logger.debug("Arguments are: " + Arrays.asList(args));
        }
        try {
            if (this.m_unmarshaller == null) {
                throw new IllegalStateException("Target MBeanServer is not set. Either call setMBeanServer or register this MBean");
            }
            Method m = this.getMBeanServerMethod(name, signature, params);
            Object result = this.invokeMBeanServerMethod(m, args);
            InvocationResult invocationResult = new InvocationResult();
            invocationResult.setResult(result);
            return invocationResult;
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getMBeanServerMethod(String name, String[] signature, Class[] params) throws NoSuchMethodException {
        MethodTernaryTree methodTernaryTree = this.m_methods;
        synchronized (methodTernaryTree) {
            Method m = (Method)this.m_methods.get(name, signature);
            if (m == null) {
                try {
                    m = (class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = InvokerAdaptorInterceptor.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getMethod(name, params);
                }
                catch (NoSuchMethodException x) {
                    if ("removeNotificationListener".equals(name)) {
                        Class[] newParams = new Class[]{params[0], params[1]};
                        m = (class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = InvokerAdaptorInterceptor.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getMethod(name, newParams);
                    }
                    throw x;
                }
                this.m_methods.put(name, signature, m);
            }
            return m;
        }
    }

    private Object invokeMBeanServerMethod(Method method, Object[] params) throws Exception {
        if ("removeNotificationListener".equals(method.getName())) {
            Object[] newParams = new Object[]{params[0], params[1]};
            return method.invoke((Object)this.m_unmarshaller, newParams);
        }
        return method.invoke((Object)this.m_unmarshaller, params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

