/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.naming;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.naming.CosNamingServiceMBean;

public class CosNamingService
implements CosNamingServiceMBean {
    private int m_port;
    private boolean m_running;
    private Process m_process;
    private InputStreamConsumer m_output;
    private InputStreamConsumer m_error;
    private long m_delay;

    public CosNamingService() {
        this(900);
    }

    public CosNamingService(int port) {
        this.m_port = port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean isRunning() {
        return this.m_running;
    }

    public void setDelay(long delay) {
        this.m_delay = delay;
    }

    public long getDelay() {
        return this.m_delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.isRunning()) {
            final Logger logger = this.getLogger();
            final Object lock = new Object();
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block9: {
                        try {
                            CosNamingService.this.m_process = Runtime.getRuntime().exec("tnameserv -ORBInitialPort " + CosNamingService.this.getPort());
                            if (logger.isEnabledFor(10)) {
                                logger.debug("Process created: " + CosNamingService.this.m_process);
                            }
                            CosNamingService.this.m_output = new InputStreamConsumer(CosNamingService.this.m_process.getInputStream());
                            CosNamingService.this.m_error = new InputStreamConsumer(CosNamingService.this.m_process.getErrorStream());
                            CosNamingService.this.m_output.start();
                            CosNamingService.this.m_error.start();
                            Thread.sleep(CosNamingService.this.getDelay());
                            Object object = lock;
                            synchronized (object) {
                                lock.notifyAll();
                            }
                            int result = CosNamingService.this.m_process.waitFor();
                            if (logger.isEnabledFor(10)) {
                                logger.debug("Exit value is: " + result);
                            }
                            if (CosNamingService.this.isRunning()) {
                                throw new IOException("Unexpected exception (maybe the port " + CosNamingService.this.getPort() + " is already in use)");
                            }
                        }
                        catch (IOException x) {
                            logger.error("Could not create process", x);
                        }
                        catch (InterruptedException x) {
                            if (!logger.isEnabledFor(20)) break block9;
                            logger.info("Interrupted", x);
                        }
                    }
                }
            }, "CosNamingService Thread");
            thread.start();
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait();
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            if (logger.isEnabledFor(0)) {
                logger.trace("CosNamingService started");
            }
            this.m_running = true;
        }
    }

    public void stop() {
        block2: {
            if (!this.isRunning()) break block2;
            this.m_running = false;
            this.m_process.destroy();
            this.m_output.interrupt();
            this.m_error.interrupt();
            try {
                Thread.sleep(this.m_delay);
            }
            catch (InterruptedException x) {}
        }
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private class InputStreamConsumer
    extends Thread {
        private InputStream m_stream;
        private byte[] m_buffer = new byte[512];

        public InputStreamConsumer(InputStream stream) {
            super("Stream Consumer Thread");
            this.m_stream = new BufferedInputStream(stream);
            this.setDaemon(true);
        }

        public void run() {
            Logger logger = CosNamingService.this.getLogger();
            while (!this.isInterrupted()) {
                try {
                    int read = -1;
                    while ((read = this.m_stream.read(this.m_buffer)) >= 0) {
                        if (!logger.isEnabledFor(20)) continue;
                        logger.info(new String(this.m_buffer, 0, read));
                    }
                }
                catch (InterruptedIOException x) {
                    break;
                }
                catch (IOException x) {
                    logger.info("Error while consuming process stream", x);
                }
            }
        }
    }
}

