/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class EndianUtil {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;

    public static final short swapShort(short value) {
        return (short)(((value & 0xFF) << 8) + (value >> 8 & 0xFF));
    }

    public static final int swapInteger(int value) {
        return ((value & 0xFF) << 24) + ((value >> 8 & 0xFF) << 16) + ((value >> 16 & 0xFF) << 8) + (value >> 24 & 0xFF);
    }

    public static final long swapLong(long value) {
        return ((value & 0xFFL) << 56) + ((value >> 8 & 0xFFL) << 48) + ((value >> 16 & 0xFFL) << 40) + ((value >> 24 & 0xFFL) << 32) + ((value >> 32 & 0xFFL) << 24) + ((value >> 40 & 0xFFL) << 16) + ((value >> 48 & 0xFFL) << 8) + (value >> 56 & 0xFFL);
    }

    public static final float swapFloat(float value) {
        return Float.intBitsToFloat(EndianUtil.swapInteger(Float.floatToIntBits(value)));
    }

    public static final double swapDouble(double value) {
        return Double.longBitsToDouble(EndianUtil.swapLong(Double.doubleToLongBits(value)));
    }

    public static final void writeSwappedShort(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    public static final short readSwappedShort(byte[] data, int offset) {
        return (short)((data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8));
    }

    public static final int readSwappedUnsignedShort(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8);
    }

    public static final void writeSwappedInteger(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
        data[offset + 2] = (byte)(value >> 16 & 0xFF);
        data[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    public static final int readSwappedInteger(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
    }

    public static final long readSwappedUnsignedInteger(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
    }

    public static final void writeSwappedLong(byte[] data, int offset, long value) {
        data[offset] = (byte)(value & 0xFFL);
        data[offset + 1] = (byte)(value >> 8 & 0xFFL);
        data[offset + 2] = (byte)(value >> 16 & 0xFFL);
        data[offset + 3] = (byte)(value >> 24 & 0xFFL);
        data[offset + 4] = (byte)(value >> 32 & 0xFFL);
        data[offset + 5] = (byte)(value >> 40 & 0xFFL);
        data[offset + 6] = (byte)(value >> 48 & 0xFFL);
        data[offset + 7] = (byte)(value >> 56 & 0xFFL);
    }

    public static final long readSwappedLong(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24) + ((data[offset + 4] & 0xFF) << 32) + ((data[offset + 5] & 0xFF) << 40) + ((data[offset + 6] & 0xFF) << 48) + ((data[offset + 7] & 0xFF) << 56);
    }

    public static final void writeSwappedFloat(byte[] data, int offset, float value) {
        EndianUtil.writeSwappedInteger(data, offset, Float.floatToIntBits(value));
    }

    public static final float readSwappedFloat(byte[] data, int offset) {
        return Float.intBitsToFloat(EndianUtil.readSwappedInteger(data, offset));
    }

    public static final void writeSwappedDouble(byte[] data, int offset, double value) {
        EndianUtil.writeSwappedLong(data, offset, Double.doubleToLongBits(value));
    }

    public static final double readSwappedDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(EndianUtil.readSwappedLong(data, offset));
    }

    public static final void writeSwappedShort(OutputStream output, int value) throws IOException {
        output.write((byte)(value & 0xFF));
        output.write((byte)(value >> 8 & 0xFF));
    }

    public static final short readSwappedShort(InputStream input) throws IOException {
        return (short)((EndianUtil.read(input) & 0xFF) + ((EndianUtil.read(input) & 0xFF) << 8));
    }

    public static final int readSwappedUnsignedShort(InputStream input) throws IOException {
        int value1 = EndianUtil.read(input);
        int value2 = EndianUtil.read(input);
        return (value1 & 0xFF) + ((value2 & 0xFF) << 8);
    }

    public static final void writeSwappedInteger(OutputStream output, int value) throws IOException {
        output.write((byte)(value & 0xFF));
        output.write((byte)(value >> 8 & 0xFF));
        output.write((byte)(value >> 16 & 0xFF));
        output.write((byte)(value >> 24 & 0xFF));
    }

    public static final int readSwappedInteger(InputStream input) throws IOException {
        int value1 = EndianUtil.read(input);
        int value2 = EndianUtil.read(input);
        int value3 = EndianUtil.read(input);
        int value4 = EndianUtil.read(input);
        return (value1 & 0xFF) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16) + ((value4 & 0xFF) << 24);
    }

    public static final long readSwappedUnsignedInteger(InputStream input) throws IOException {
        int value1 = EndianUtil.read(input);
        int value2 = EndianUtil.read(input);
        int value3 = EndianUtil.read(input);
        int value4 = EndianUtil.read(input);
        return (value1 & 0xFF) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16) + ((value4 & 0xFF) << 24);
    }

    public static final void writeSwappedLong(OutputStream output, long value) throws IOException {
        output.write((byte)(value & 0xFFL));
        output.write((byte)(value >> 8 & 0xFFL));
        output.write((byte)(value >> 16 & 0xFFL));
        output.write((byte)(value >> 24 & 0xFFL));
        output.write((byte)(value >> 32 & 0xFFL));
        output.write((byte)(value >> 40 & 0xFFL));
        output.write((byte)(value >> 48 & 0xFFL));
        output.write((byte)(value >> 56 & 0xFFL));
    }

    public static final long readSwappedLong(InputStream input) throws IOException {
        int value1 = EndianUtil.read(input);
        int value2 = EndianUtil.read(input);
        int value3 = EndianUtil.read(input);
        int value4 = EndianUtil.read(input);
        int value5 = EndianUtil.read(input);
        int value6 = EndianUtil.read(input);
        int value7 = EndianUtil.read(input);
        int value8 = EndianUtil.read(input);
        return (value1 & 0xFF) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16) + ((value4 & 0xFF) << 24) + ((value5 & 0xFF) << 32) + ((value6 & 0xFF) << 40) + ((value7 & 0xFF) << 48) + ((value8 & 0xFF) << 56);
    }

    public static final void writeSwappedFloat(OutputStream output, float value) throws IOException {
        EndianUtil.writeSwappedInteger(output, Float.floatToIntBits(value));
    }

    public static final float readSwappedFloat(InputStream input) throws IOException {
        return Float.intBitsToFloat(EndianUtil.readSwappedInteger(input));
    }

    public static final void writeSwappedDouble(OutputStream output, double value) throws IOException {
        EndianUtil.writeSwappedLong(output, Double.doubleToLongBits(value));
    }

    public static final double readSwappedDouble(InputStream input) throws IOException {
        return Double.longBitsToDouble(EndianUtil.readSwappedLong(input));
    }

    private static final int read(InputStream input) throws IOException {
        int value = input.read();
        if (-1 == value) {
            throw new EOFException("Unexpected EOF reached");
        }
        return value;
    }
}

