/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.dsn.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.mailet.Mailet;
import org.nhindirect.common.mail.dsn.DSNFailureTextBodyPartGenerator;
import org.nhindirect.common.mail.dsn.DSNGenerator;
import org.nhindirect.common.mail.dsn.DSNMessageHeaders;
import org.nhindirect.common.mail.dsn.DSNRecipientHeaders;
import org.nhindirect.common.mail.dsn.DSNStandard;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;

public abstract class AbstractDSNCreator
implements DSNCreator {
    protected Mailet mailet;
    protected DSNGenerator generator;
    protected String postmasterMailbox;
    protected String reportingMta;
    protected DSNFailureTextBodyPartGenerator textGenerator;
    protected String dsnStatus;

    @Override
    public MimeMessage createDSNFailure(Tx tx, NHINDAddressCollection failedRecipeints) throws MessagingException {
        Collection<MimeMessage> dsnMessages = this.createDSNFailure(tx, failedRecipeints, true);
        if (dsnMessages != null && dsnMessages.size() > 0) {
            return dsnMessages.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<MimeMessage> createDSNFailure(Tx tx, NHINDAddressCollection failedRecipeints, boolean useSenderDomainForPostmaster) throws MessagingException {
        Map<InternetAddress, Collection<NHINDAddress>> dsnMessagePostmasterToFailedRecipMap;
        TxDetail fullHeaders;
        TxDetail origMessId;
        ArrayList<MimeMessage> retVal = new ArrayList<MimeMessage>();
        InternetAddress originalSender = null;
        String originalSubject = "";
        String originalMessageId = "";
        Enumeration<Header> fullMessageHeaders = null;
        ArrayList<NHINDAddress> failedRecipAddresses = new ArrayList<NHINDAddress>();
        TxDetail subject = tx.getDetail(TxDetailType.SUBJECT);
        if (subject != null) {
            originalSubject = subject.getDetailValue();
        }
        if ((origMessId = tx.getDetail(TxDetailType.MSG_ID)) != null) {
            originalMessageId = origMessId.getDetailValue();
        }
        if ((fullHeaders = tx.getDetail(TxDetailType.MSG_FULL_HEADERS)) != null) {
            fullMessageHeaders = this.convertStringToHeaders(fullHeaders.getDetailValue());
        }
        DSNMessageHeaders messageDSNHeaders = new DSNMessageHeaders(this.reportingMta, originalMessageId, DSNStandard.MtaNameType.DNS);
        TxDetail sender = tx.getDetail(TxDetailType.FROM);
        if (sender != null) {
            originalSender = new InternetAddress(sender.getDetailValue());
        }
        if ((dsnMessagePostmasterToFailedRecipMap = this.groupPostMasterAndFailedRecips(sender, failedRecipeints, useSenderDomainForPostmaster)).size() > 0) {
            for (Map.Entry<InternetAddress, Collection<NHINDAddress>> entry : dsnMessagePostmasterToFailedRecipMap.entrySet()) {
                ArrayList<DSNRecipientHeaders> recipientDSNHeaders = new ArrayList<DSNRecipientHeaders>();
                for (NHINDAddress incompleteRecip : entry.getValue()) {
                    DSNRecipientHeaders dsnRecipHeaders = new DSNRecipientHeaders(DSNStandard.DSNAction.FAILED, DSNStandard.DSNStatus.getStatus((int)5, (String)this.dsnStatus), (Address)incompleteRecip);
                    recipientDSNHeaders.add(dsnRecipHeaders);
                    failedRecipAddresses.add(incompleteRecip);
                }
                MimeBodyPart textBodyPart = this.textGenerator.generate((Address)originalSender, failedRecipAddresses, fullMessageHeaders);
                MimeMessage dsnMessage = this.generator.createDSNMessage(originalSender, originalSubject, entry.getKey(), recipientDSNHeaders, messageDSNHeaders, textBodyPart);
                retVal.add(dsnMessage);
            }
        }
        return retVal;
    }

    protected Map<InternetAddress, Collection<NHINDAddress>> groupPostMasterAndFailedRecips(TxDetail sender, NHINDAddressCollection failedRecipeints, boolean useSenderAsPostmaster) throws MessagingException {
        HashMap<InternetAddress, Collection<NHINDAddress>> postmasterToFailed = new HashMap<InternetAddress, Collection<NHINDAddress>>();
        if (useSenderAsPostmaster) {
            if (sender != null) {
                InternetAddress originalSender = new InternetAddress(sender.getDetailValue());
                InternetAddress postmaster = new InternetAddress(this.postmasterMailbox + "@" + this.getAddressDomain(originalSender));
                postmasterToFailed.put(postmaster, (Collection<NHINDAddress>)failedRecipeints);
            }
        } else {
            for (NHINDAddress failedRecipeint : failedRecipeints) {
                InternetAddress postmaster = new InternetAddress(this.postmasterMailbox + "@" + failedRecipeint.getHost().toLowerCase(Locale.getDefault()));
                ArrayList<NHINDAddress> group = (ArrayList<NHINDAddress>)postmasterToFailed.get(postmaster);
                if (group == null) {
                    group = new ArrayList<NHINDAddress>();
                    postmasterToFailed.put(postmaster, group);
                }
                group.add(failedRecipeint);
            }
        }
        return postmasterToFailed;
    }

    protected String getAddressDomain(InternetAddress theAddress) {
        String retVal = "";
        String address = theAddress.getAddress();
        int index = address.indexOf(60);
        if (index > -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(62)) > -1) {
            address = address.substring(0, index);
        }
        if ((index = address.indexOf("@")) >= 0) {
            retVal = address.substring(index + 1);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration<Header> convertStringToHeaders(String asString) {
        InputStream str = IOUtils.toInputStream((String)asString);
        try {
            InternetHeaders headers = new InternetHeaders(str);
            Enumeration enumeration = headers.getAllHeaders();
            return enumeration;
        }
        catch (Exception exception) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)str);
        }
        return null;
    }
}

