/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import com.google.inject.Module;
import com.google.inject.Provider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.Mailet;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.gateway.GatewayConfiguration;
import org.nhindirect.gateway.smtp.GatewayState;
import org.nhindirect.gateway.smtp.MessageProcessResult;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.SmtpAgentException;
import org.nhindirect.gateway.smtp.SmtpAgentFactory;
import org.nhindirect.gateway.smtp.config.SmptAgentConfigFactory;
import org.nhindirect.gateway.smtp.config.SmtpAgentConfig;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.smtp.dsn.provider.RejectedRecipientDSNCreatorProvider;
import org.nhindirect.gateway.smtp.james.mailet.AbstractNotificationAwareMailet;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.cryptography.SMIMEStandard;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.stagent.options.OptionsManager;

public class NHINDSecurityAndTrustMailet
extends AbstractNotificationAwareMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(NHINDSecurityAndTrustMailet.class);
    protected static final String GENERAL_DSN_OPTION = "General";
    protected static final String RELIABLE_DSN_OPTION = "ReliableAndTimely";
    protected SmtpAgent agent;
    protected boolean autoDSNForGeneral = false;
    protected boolean autoDSNForTimelyAndReliable = false;

    private static synchronized void initJVMParams() {
        HashMap<String, String> JVM_PARAMS = new HashMap<String, String>();
        JVM_PARAMS.put("MessageMonitoringServiceURL", "org.nhindirect.gateway.smtp.james.mailet.TxServiceURL");
        JVM_PARAMS.put("AutoDSNFailueCreation", "org.nhindirect.gateway.smtp.james.mailet.AutoDSNFailueCreation");
        OptionsManager.addInitParameters(JVM_PARAMS);
    }

    @Override
    public void init() throws MessagingException {
        LOGGER.info((Object)"Initializing NHINDSecurityAndTrustMailet");
        super.init();
        String configURLParam = this.getInitParameter("ConfigURL");
        if (configURLParam == null || configURLParam.isEmpty()) {
            LOGGER.error((Object)"NHINDSecurityAndTrustMailet Configuration URL cannot be empty or null.");
            throw new MessagingException("NHINDSecurityAndTrustMailet Configuration URL cannot be empty or null.");
        }
        URL configURL = null;
        try {
            configURL = new URL(configURLParam);
        }
        catch (MalformedURLException ex) {
            LOGGER.error((Object)("Invalid configuration URL:" + ex.getMessage()), (Throwable)ex);
            throw new MessagingException("NHINDSecurityAndTrustMailet Configuration URL cannot be empty or null.", (Exception)ex);
        }
        Collection<Module> modules = this.getInitModules();
        try {
            Provider<SmtpAgentConfig> configProvider = this.getConfigProvider();
            this.agent = SmtpAgentFactory.createAgent(configURL, configProvider, null, modules);
        }
        catch (SmtpAgentException e) {
            LOGGER.error((Object)("Failed to create the SMTP agent: " + e.getMessage()), (Throwable)((Object)e));
            throw new MessagingException("Failed to create the SMTP agent: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.agent == null) {
            LOGGER.error((Object)"Failed to create the SMTP agent. Reason unknown.");
            throw new MessagingException("Failed to create the SMTP agent.  Reason unknown.");
        }
        String dnsCreateOptions = GatewayConfiguration.getConfigurationParam("AutoDSNFailueCreation", (Mailet)this, RELIABLE_DSN_OPTION);
        for (String dsnOption : dnsCreateOptions.split(",")) {
            if (dsnOption.equalsIgnoreCase(RELIABLE_DSN_OPTION)) {
                this.autoDSNForTimelyAndReliable = true;
                continue;
            }
            if (!dsnOption.equalsIgnoreCase(GENERAL_DSN_OPTION)) continue;
            this.autoDSNForGeneral = true;
        }
        GatewayState gwState = GatewayState.getInstance();
        if (gwState.isAgentSettingManagerRunning()) {
            gwState.stopAgentSettingsManager();
        }
        gwState.setSmtpAgent(this.agent);
        gwState.setSmptAgentConfig(SmptAgentConfigFactory.createSmtpAgentConfig(configURL, this.getConfigProvider(), null));
        gwState.startAgentSettingsManager();
        LOGGER.info((Object)"NHINDSecurityAndTrustMailet initialization complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Mail mail) throws MessagingException {
        GatewayState.getInstance().lockForProcessing();
        try {
            Collection<NotificationMessage> notifications;
            Tx txToMonitor = null;
            LOGGER.trace((Object)"Entering service(Mail mail)");
            this.onPreprocessMessage(mail);
            MimeMessage msg = mail.getMessage();
            NHINDAddressCollection recipients = this.getMailRecipients(mail);
            NHINDAddress sender = this.getMailSender(mail);
            LOGGER.info((Object)("Proccessing incoming message from sender " + sender.toString()));
            MessageProcessResult result = null;
            boolean isOutgoing = this.isOutgoing(msg, sender);
            if (isOutgoing) {
                txToMonitor = this.getTxToTrack(msg, sender, recipients);
            }
            NHINDAddressCollection originalRecipList = NHINDAddressCollection.create((Collection)recipients);
            try {
                LOGGER.trace((Object)"Calling agent.processMessage");
                result = this.agent.processMessage(msg, recipients, sender);
                LOGGER.trace((Object)"Finished calling agent.processMessage");
                if (result == null) {
                    LOGGER.error((Object)"Failed to process message.  processMessage returned null.");
                    this.onMessageRejected(mail, originalRecipList, sender, isOutgoing, txToMonitor, null);
                    mail.setState("ghost");
                    LOGGER.trace((Object)"Exiting service(Mail mail)");
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to process message: " + e.getMessage()), (Throwable)e);
                this.onMessageRejected(mail, originalRecipList, sender, isOutgoing, txToMonitor, e);
                mail.setState("ghost");
                LOGGER.trace((Object)"Exiting service(Mail mail)");
                return;
            }
            if (result.getProcessedMessage() == null) {
                LOGGER.debug((Object)"Processed message is null.  GHOST and eat the message.");
                this.onMessageRejected(mail, recipients, sender, null);
                mail.setState("ghost");
                return;
            }
            mail.setMessage((MimeMessage)result.getProcessedMessage().getMessage());
            if (result.getProcessedMessage().getRejectedRecipients() != null && result.getProcessedMessage().getRejectedRecipients().size() > 0 && mail.getRecipients() != null && mail.getRecipients().size() > 0) {
                ArrayList<MailAddress> newRCPTList = new ArrayList<MailAddress>();
                for (MailAddress rctpAdd : mail.getRecipients()) {
                    if (this.isRcptRejected(rctpAdd, result.getProcessedMessage().getRejectedRecipients())) continue;
                    newRCPTList.add(rctpAdd);
                }
                mail.setRecipients(newRCPTList);
            }
            if ((notifications = result.getNotificationMessages()) != null && notifications.size() > 0) {
                LOGGER.info((Object)"MDN messages requested.  Sending MDN \"processed\" messages");
                for (NotificationMessage message : notifications) {
                    try {
                        this.getMailetContext().sendMail((MimeMessage)message);
                    }
                    catch (Throwable t) {
                        LOGGER.error((Object)"Error sending MDN message.", t);
                    }
                }
            }
            this.trackMessage(txToMonitor, isOutgoing);
            this.onPostprocessMessage(mail, result, isOutgoing, txToMonitor);
            LOGGER.trace((Object)"Exiting service(Mail mail)");
        }
        finally {
            GatewayState.getInstance().unlockFromProcessing();
        }
    }

    private boolean isRcptRejected(MailAddress rctpAdd, NHINDAddressCollection rejectedRecips) {
        for (NHINDAddress rejectedRecip : rejectedRecips) {
            if (!rejectedRecip.getAddress().equals(rctpAdd.toInternetAddress().toString())) continue;
            return true;
        }
        return false;
    }

    protected Provider<SmtpAgentConfig> getConfigProvider() {
        return null;
    }

    protected void onPreprocessMessage(Mail mail) {
    }

    protected void onMessageRejected(Mail mail, NHINDAddressCollection recipients, NHINDAddress sender, Throwable t) {
    }

    protected void onMessageRejected(Mail mail, NHINDAddressCollection recipients, NHINDAddress sender, boolean isOutgoing, Tx tx, Throwable t) {
        boolean timely;
        boolean sendDSN = false;
        if (isOutgoing && tx != null && tx.getMsgType() == TxMessageType.IMF && ((timely = TxUtil.isReliableAndTimelyRequested((Tx)tx)) && this.autoDSNForTimelyAndReliable || !timely && this.autoDSNForGeneral)) {
            sendDSN = true;
        }
        if (sendDSN) {
            this.sendDSN(tx, recipients, true);
        }
        this.onMessageRejected(mail, recipients, sender, t);
    }

    protected void onPostprocessMessage(Mail mail, MessageProcessResult result) {
    }

    protected void onPostprocessMessage(Mail mail, MessageProcessResult result, boolean isOutgoing, Tx tx) {
        boolean timely;
        boolean sendDSN = false;
        if (isOutgoing && tx != null && tx.getMsgType() == TxMessageType.IMF && result.getProcessedMessage().hasRejectedRecipients() && ((timely = TxUtil.isReliableAndTimelyRequested((Tx)tx)) && this.autoDSNForTimelyAndReliable || !timely && this.autoDSNForGeneral)) {
            sendDSN = true;
        }
        if (sendDSN) {
            this.sendDSN(tx, result.getProcessedMessage().getRejectedRecipients(), true);
        }
        this.onPostprocessMessage(mail, result);
    }

    protected boolean isOutgoing(MimeMessage msg, NHINDAddress sender) {
        if (this.agent.getAgent() == null || this.agent.getAgent().getDomains() == null) {
            return false;
        }
        if (!sender.isInDomain(this.agent.getAgent().getDomains())) {
            return false;
        }
        return !SMIMEStandard.isEncrypted((MimeMessage)msg);
    }

    @Override
    protected Provider<DSNCreator> getDSNProvider() {
        return new RejectedRecipientDSNCreatorProvider((Mailet)this);
    }

    protected void trackMessage(Tx tx, boolean isOutgoing) {
        boolean track = false;
        if (tx != null) {
            switch (tx.getMsgType()) {
                case IMF: {
                    track = isOutgoing;
                }
            }
        }
        if (track) {
            try {
                this.txService.trackMessage(tx);
            }
            catch (ServiceException ex) {
                LOGGER.warn((Object)"Failed to submit message to monitoring service.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        GatewayState.getInstance().lockForUpdating();
        GatewayState.getInstance().unlockFromUpdating();
    }

    static {
        NHINDSecurityAndTrustMailet.initJVMParams();
    }
}

