/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.nhindirect.gateway.smtp.config.SmtpAgentConfig;
import org.nhindirect.gateway.smtp.provider.WSSmtpAgentConfigProvider;
import org.nhindirect.gateway.smtp.provider.XMLSmtpAgentConfigProvider;
import org.nhindirect.stagent.NHINDAgent;

public class SmtpAgentConfigModule
extends AbstractModule {
    private final URL configLocation;
    private final Provider<SmtpAgentConfig> smtpAgentConfigProvider;
    private final Provider<NHINDAgent> agentProvider;

    public static SmtpAgentConfigModule create(URL configLocation, Provider<SmtpAgentConfig> smtpAgentConfigProvider, Provider<NHINDAgent> agentProvider) {
        return new SmtpAgentConfigModule(configLocation, smtpAgentConfigProvider, agentProvider);
    }

    private SmtpAgentConfigModule(URL configLocation, Provider<SmtpAgentConfig> smtpAgentConfigProvider, Provider<NHINDAgent> agentProvider) {
        this.configLocation = configLocation;
        this.smtpAgentConfigProvider = smtpAgentConfigProvider;
        this.agentProvider = agentProvider;
    }

    protected void configure() {
        Object provider = this.smtpAgentConfigProvider;
        if (provider == null) {
            if (this.configLocation.getProtocol().equalsIgnoreCase("HTTP") || this.configLocation.getProtocol().equalsIgnoreCase("HTTPS")) {
                provider = new WSSmtpAgentConfigProvider(this.configLocation, this.agentProvider);
            } else {
                File fl = FileUtils.toFile((URL)this.configLocation);
                provider = new XMLSmtpAgentConfigProvider(fl.getAbsolutePath(), this.agentProvider);
            }
        }
        this.bind(SmtpAgentConfig.class).toProvider(provider);
    }
}

