/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePart;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.mail.MimeStandard;
import org.nhindirect.stagent.parser.EntitySerializer;

public class MimeEntity
extends MimeBodyPart {
    public MimeEntity() {
    }

    public MimeEntity(InternetHeaders headers, byte[] content) throws MessagingException {
        super(headers, content);
    }

    public MimeEntity(InputStream inStream) throws MessagingException {
        super(inStream);
    }

    public boolean isMultiPart() {
        String contentType;
        try {
            contentType = this.getContentType();
        }
        catch (MessagingException e) {
            return false;
        }
        if (contentType == null || contentType.length() == 0) {
            return false;
        }
        return MimeStandard.contains(contentType, "multipart");
    }

    public void verifyContentType(String expectedType) throws MimeException {
        try {
            String parsedType = this.getContentType();
            if (parsedType == null || !MimeStandard.equals(parsedType, expectedType)) {
                throw new MimeException(MimeError.ContentTypeMismatch);
            }
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.ContentTypeMismatch);
        }
    }

    public void verifyContentType(ContentType expectedType) throws MimeException {
        try {
            String parsedType = this.getContentType();
            if (parsedType == null || !MimeStandard.equals(parsedType, expectedType.toString())) {
                throw new MimeException(MimeError.ContentTypeMismatch);
            }
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.ContentTypeMismatch);
        }
    }

    public void verifyTransferEncoding(String expectedEncoding) throws MimeException {
        try {
            String transferEncodingHeader = this.getEncoding();
            if (transferEncodingHeader == null || transferEncodingHeader.compareToIgnoreCase(expectedEncoding) != 0) {
                throw new MimeException(MimeError.TransferEncodingMismatch);
            }
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.TransferEncodingMismatch);
        }
    }

    public String toString() {
        return EntitySerializer.Default.serialize((MimePart)this);
    }

    public byte[] getContentAsBytes() {
        byte[] retVal = null;
        try {
            int read;
            InputStream inStream = this.getRawInputStream();
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((read = inStream.read(buffer)) > -1) {
                oStream.write(buffer, 0, read);
            }
            retVal = oStream.toByteArray();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.InvalidBody, e);
        }
        return retVal;
    }
}

