/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.module;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.Collection;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.annotation.AgentDomains;
import org.nhindirect.stagent.utils.InjectionUtils;

public class AgentModule
extends AbstractModule {
    private final Collection<String> domains;
    private final Module publicCertModule;
    private final Module privateCertModule;
    private final Module trustAnchorModule;
    private final Provider<NHINDAgent> agentProvider;

    public static AgentModule create(Collection<String> domains, Module publicCertModule, Module privateCertModule, Module trustAnchorModule) {
        return new AgentModule(domains, publicCertModule, privateCertModule, trustAnchorModule, null);
    }

    public static AgentModule create(Provider<NHINDAgent> agentProvider) {
        return new AgentModule(null, null, null, null, agentProvider);
    }

    private AgentModule(Collection<String> domains, Module publicCertModule, Module privateCertModule, Module trustAnchorModule, Provider<NHINDAgent> agentProvider) {
        this.domains = domains;
        this.publicCertModule = publicCertModule;
        this.privateCertModule = privateCertModule;
        this.trustAnchorModule = trustAnchorModule;
        this.agentProvider = agentProvider;
    }

    protected void configure() {
        if (this.agentProvider != null) {
            this.bind(NHINDAgent.class).toProvider(this.agentProvider);
        } else {
            this.install(this.publicCertModule);
            this.install(this.privateCertModule);
            this.install(this.trustAnchorModule);
            this.bind(InjectionUtils.collectionOf(String.class)).annotatedWith(AgentDomains.class).toInstance(this.domains);
        }
    }
}

