/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.james.mailet;

import com.google.inject.Provider;
import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.Mailet;
import org.nhind.mail.service.DocumentRepository;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.gateway.smtp.NotificationProducer;
import org.nhindirect.gateway.smtp.NotificationSettings;
import org.nhindirect.gateway.smtp.ReliableDispatchedNotificationProducer;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.smtp.dsn.provider.FailedDeliveryDSNCreatorProvider;
import org.nhindirect.gateway.smtp.james.mailet.AbstractNotificationAwareMailet;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.xd.routing.RoutingResolver;
import org.nhindirect.xd.routing.impl.RoutingResolverImpl;
import org.nhindirect.xd.transform.MimeXdsTransformer;
import org.nhindirect.xd.transform.impl.DefaultMimeXdsTransformer;

public class DirectXdMailet
extends AbstractNotificationAwareMailet {
    protected static final String RELIABLE_DELIVERY_OPTION = "X-DIRECT-FINAL-DESTINATION-DELIVERY=optional,true";
    private String endpointUrl;
    private String configServiceUrl;
    private MimeXdsTransformer mimeXDSTransformer;
    private DocumentRepository documentRepository;
    private RoutingResolver resolver;
    protected NotificationProducer notificationProducer;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DirectXdMailet.class);

    public void service(Mail mail) throws MessagingException {
        LOGGER.info((Object)"Servicing DirectXdMailet");
        if (StringUtils.isBlank((String)this.endpointUrl)) {
            LOGGER.error((Object)"DirectXdMailet endpoint URL cannot be empty or null.");
            throw new MessagingException("DirectXdMailet endpoint URL cannot be empty or null.");
        }
        boolean successfulTransaction = false;
        MimeMessage msg = mail.getMessage();
        boolean isReliableAndTimely = TxUtil.isReliableAndTimelyRequested((MimeMessage)msg);
        NHINDAddressCollection initialRecipients = this.getMailRecipients(mail);
        NHINDAddressCollection xdRecipients = new NHINDAddressCollection();
        NHINDAddress sender = this.getMailSender(mail);
        Tx txToTrack = null;
        ArrayList<String> recipAddresses = new ArrayList<String>();
        for (NHINDAddress addr : initialRecipients) {
            recipAddresses.add(addr.getAddress());
        }
        if (this.getResolver().hasXdEndpoints(recipAddresses)) {
            LOGGER.info((Object)"Recipients include XD endpoints");
            try {
                for (String s : this.getResolver().getXdEndpoints(recipAddresses)) {
                    xdRecipients.add((Object)new NHINDAddress(s));
                }
                txToTrack = this.getTxToTrack(msg, sender, xdRecipients);
                msg.setRecipients(Message.RecipientType.TO, (Address[])xdRecipients.toArray((Object[])new Address[0]));
                ProvideAndRegisterDocumentSetRequestType request = this.getMimeXDSTransformer().transform(msg);
                for (String directTo : recipAddresses) {
                    String response = this.getDocumentRepository().forwardRequest(this.endpointUrl, request, directTo, sender.toString());
                    if (!this.isSuccessful(response)) {
                        LOGGER.error((Object)"DirectXdMailet failed to deliver XD message.");
                        LOGGER.error((Object)response);
                        continue;
                    }
                    if (!isReliableAndTimely || txToTrack == null || txToTrack.getMsgType() != TxMessageType.IMF) continue;
                    successfulTransaction = true;
                    Collection notifications = this.notificationProducer.produce(new Message(msg), xdRecipients.toInternetAddressCollection());
                    if (notifications == null || notifications.size() <= 0) continue;
                    LOGGER.debug((Object)"Sending MDN \"dispathed\" messages");
                    for (NotificationMessage message : notifications) {
                        try {
                            message.setHeader("Disposition-Notification-Options", RELIABLE_DELIVERY_OPTION);
                            message.saveChanges();
                            this.getMailetContext().sendMail((MimeMessage)message);
                        }
                        catch (Throwable t) {
                            LOGGER.error((Object)"Error sending MDN dispatched message.", t);
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)"DirectXdMailet delivery failure", e);
            }
        }
        if (this.getResolver().hasSmtpEndpoints(recipAddresses)) {
            LOGGER.info((Object)"Recipients include SMTP endpoints");
            mail.setRecipients(this.getSmtpRecips(recipAddresses));
        } else {
            LOGGER.info((Object)"Recipients do not include SMTP endpoints");
            mail.setState("ghost");
        }
        if (!successfulTransaction && txToTrack != null && txToTrack.getMsgType() == TxMessageType.IMF) {
            this.sendDSN(txToTrack, xdRecipients, false);
        }
    }

    private Collection<MailAddress> getSmtpRecips(Collection<String> recips) throws AddressException {
        ArrayList<MailAddress> addrs = new ArrayList<MailAddress>();
        for (String s : this.getResolver().getSmtpEndpoints(recips)) {
            addrs.add(new MailAddress(s));
        }
        return addrs;
    }

    private boolean isSuccessful(String response) {
        return !StringUtils.contains((String)response, (String)"Failure");
    }

    public void init() throws MessagingException {
        LOGGER.info((Object)"Initializing DirectXdMailet");
        super.init();
        this.endpointUrl = this.getInitParameter("EndpointURL");
        if (StringUtils.isBlank((String)this.endpointUrl)) {
            LOGGER.error((Object)"DirectXdMailet endpoint URL cannot be empty or null.");
            throw new MessagingException("DirectXdMailet endpoint URL cannot be empty or null.");
        }
        try {
            this.configServiceUrl = this.getInitParameter("ConfigURL");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notificationProducer = new ReliableDispatchedNotificationProducer(new NotificationSettings(true, "Direct XD Delivery Agent", "Your message was successfully dispatched."));
    }

    protected String getEndpointUrl() {
        return this.endpointUrl;
    }

    protected void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    protected String getConfigServiceUrl() {
        return this.configServiceUrl;
    }

    protected void setConfigServiceUrl(String configServiceUrl) {
        this.configServiceUrl = configServiceUrl;
    }

    protected void setResolver(RoutingResolver resolver) {
        this.resolver = resolver;
    }

    protected RoutingResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = new RoutingResolverImpl(this.configServiceUrl);
        }
        return this.resolver;
    }

    protected void setMimeXDSTransformer(MimeXdsTransformer mimeXDSTransformer) {
        this.mimeXDSTransformer = mimeXDSTransformer;
    }

    protected MimeXdsTransformer getMimeXDSTransformer() {
        if (this.mimeXDSTransformer == null) {
            this.mimeXDSTransformer = new DefaultMimeXdsTransformer();
        }
        return this.mimeXDSTransformer;
    }

    public void setDocumentRepository(DocumentRepository documentRepository) {
        this.documentRepository = documentRepository;
    }

    public DocumentRepository getDocumentRepository() {
        if (this.documentRepository == null) {
            this.documentRepository = new DocumentRepository();
        }
        return this.documentRepository;
    }

    protected Provider<DSNCreator> getDSNProvider() {
        return new FailedDeliveryDSNCreatorProvider((Mailet)this);
    }
}

