/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.james.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;
import org.nhindirect.xd.routing.RoutingResolver;
import org.nhindirect.xd.routing.impl.RoutingResolverImpl;

public class RecipientIsXdAndNotSMIME
extends GenericMatcher {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(RecipientIsXdAndNotSMIME.class);
    private RoutingResolver routingResolver;

    public void init() {
        LOGGER.info((Object)"Initializing RecipientIsXdAndNotSMIME matcher");
        String condition = this.getCondition();
        this.routingResolver = new RoutingResolverImpl(condition);
        LOGGER.info((Object)"Initialized RecipientIsXdAndNotSMIME matcher");
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        LOGGER.info((Object)"Attempting to match XD recipients");
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
        MimeMessage message = mail.getMessage();
        if (message.isMimeType("application/x-pkcs7-mime") || message.isMimeType("application/pkcs7-mime")) {
            LOGGER.info((Object)"MimeMessage is SMIME, skipping");
            return Collections.emptyList();
        }
        for (MailAddress addr : mail.getRecipients()) {
            if (!this.routingResolver.isXdEndpoint(addr.toString())) continue;
            recipients.add(addr);
        }
        if (recipients.isEmpty()) {
            LOGGER.info((Object)"Matched no recipients");
        } else {
            for (MailAddress addr : recipients) {
                LOGGER.info((Object)("Matched recipient " + addr.toString()));
            }
        }
        return recipients;
    }
}

