/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.audit.AuditContext;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.Auditor;
import org.nhindirect.common.audit.AuditorFactory;
import org.nhindirect.common.audit.DefaultAuditContext;
import org.nhindirect.gateway.smtp.AuditEvents;
import org.nhindirect.gateway.smtp.GatewayState;
import org.nhindirect.gateway.smtp.MessageProcessResult;
import org.nhindirect.gateway.smtp.MessageProcessingSettings;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.SmtpAgentError;
import org.nhindirect.gateway.smtp.SmtpAgentException;
import org.nhindirect.gateway.smtp.SmtpAgentSettings;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.DefaultMessageEnvelope;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.MessageEnvelope;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cryptography.SMIMEStandard;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationHelper;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.stagent.parser.EntitySerializer;

public class DefaultSmtpAgent
implements SmtpAgent {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultSmtpAgent.class);
    private static final String PRINICPAL;
    private final NHINDAgent agent;
    private final SmtpAgentSettings settings;
    private Auditor auditor;

    @Inject
    public DefaultSmtpAgent(SmtpAgentSettings settings, NHINDAgent agent) {
        this(settings, agent, null);
    }

    public DefaultSmtpAgent(SmtpAgentSettings settings, NHINDAgent agent, Auditor auditor) {
        if (settings == null || agent == null) {
            throw new IllegalArgumentException("Setting and/or agent cannot be null.");
        }
        this.settings = settings;
        this.agent = agent;
        if (auditor == null) {
            this.auditor = AuditorFactory.createAuditor();
        }
    }

    @Override
    public NHINDAgent getAgent() {
        return this.agent;
    }

    @Override
    public SmtpAgentSettings getSmtpAgentSettings() {
        return this.settings;
    }

    @Inject(optional=true)
    public void setAuditor(Auditor auditor) {
        this.auditor = auditor;
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageProcessResult processMessage(MimeMessage message, NHINDAddressCollection recipients, NHINDAddress sender) {
        GatewayState.getInstance().lockForProcessing();
        try {
            LOGGER.trace((Object)"Entering processMessage(MimeMessage, NHINDAddressCollection, NHINDAddress");
            MessageProcessResult retVal = null;
            this.verifyInitialized();
            this.preProcessMessage(message, sender);
            ArrayList originalRecipList = new ArrayList(recipients);
            DefaultMessageEnvelope envelopeToProcess = null;
            try {
                envelopeToProcess = new DefaultMessageEnvelope(new Message(message), recipients, sender);
                envelopeToProcess.setAgent(this.agent);
                MessageEnvelope processEvn = this.processEnvelope((MessageEnvelope)envelopeToProcess);
                retVal = new MessageProcessResult(processEvn, null);
                if (retVal.getProcessedMessage() != null) {
                    this.postProcessMessage(retVal);
                }
            }
            catch (SmtpAgentException e) {
                LOGGER.trace((Object)"Exiting processMessage(MimeMessage, NHINDAddressCollection, NHINDAddress", (Throwable)((Object)e));
                throw e;
            }
            catch (Exception e) {
                if (envelopeToProcess != null) {
                    NHINDException exception;
                    Collection<AuditContext> contexts = this.createContextCollectionFromMessage((MessageEnvelope)envelopeToProcess, (Collection<String>)Arrays.asList(AuditEvents.DEFAULT_HEADER_CONTEXT));
                    if (e instanceof NHINDException && (exception = (NHINDException)e).getError() != null) {
                        contexts.add((AuditContext)new DefaultAuditContext("Rejected Message Reason", exception.getError().toString()));
                        if (exception.getError() != null && exception.getError() instanceof AgentException && ((AgentException)exception.getError()).getError() == AgentError.NoTrustedRecipients) {
                            StringBuilder rejectedRecips = new StringBuilder();
                            int cnt = 0;
                            for (NHINDAddress address : originalRecipList) {
                                rejectedRecips.append(address.getAddress());
                                if (++cnt >= originalRecipList.size()) continue;
                                rejectedRecips.append(", ");
                            }
                            contexts.add((AuditContext)new DefaultAuditContext("Rejected Recipients", rejectedRecips.toString()));
                        }
                    }
                    this.auditor.audit(PRINICPAL, new AuditEvent("Rejected Direct Message", "SMTP Direct Message Processing"), contexts);
                }
                LOGGER.trace((Object)"Exiting processMessage(MimeMessage, NHINDAddressCollection, NHINDAddress", (Throwable)e);
                throw new SmtpAgentException(SmtpAgentError.Unknown, e);
            }
            LOGGER.trace((Object)"Exiting processMessage(MimeMessage, NHINDAddressCollection, NHINDAddress");
            MessageProcessResult messageProcessResult = retVal;
            return messageProcessResult;
        }
        finally {
            GatewayState.getInstance().unlockFromProcessing();
        }
    }

    private void verifyInitialized() {
        if (this.agent == null) {
            throw new SmtpAgentException(SmtpAgentError.Uninitialized, "SmtpAgent not fully initialized: Security and Trust agent is null");
        }
    }

    private void preProcessMessage(MimeMessage message, NHINDAddress sender) {
        LOGGER.debug((Object)("Message Recieved from: " + sender.getAddress()));
        this.copyMessage(message, this.settings.getRawMessageSettings());
    }

    public boolean isOutgoing(MessageEnvelope envelope) {
        if (!envelope.getSender().isInDomain(this.agent.getDomains())) {
            return false;
        }
        return !SMIMEStandard.isEncrypted((MimeMessage)envelope.getMessage());
    }

    protected MessageEnvelope processEnvelope(MessageEnvelope envelope) {
        OutgoingMessage processedMessage = null;
        boolean isOutgoing = this.isOutgoing(envelope);
        if (isOutgoing) {
            if (this.auditor != null) {
                Collection<AuditContext> contexts = this.createContextCollectionFromMessage(envelope, Arrays.asList(AuditEvents.DEFAULT_HEADER_CONTEXT));
                this.auditor.audit(PRINICPAL, new AuditEvent("Outgoing Direct Message", "SMTP Direct Message Processing"), contexts);
            }
            LOGGER.debug((Object)("Sending outgoing message from " + envelope.getSender().toString() + " to STAgent"));
        } else {
            if (this.auditor != null) {
                Collection<AuditContext> contexts = this.createContextCollectionFromMessage(envelope, Arrays.asList(AuditEvents.DEFAULT_HEADER_CONTEXT));
                this.auditor.audit(PRINICPAL, new AuditEvent("Incoming Direct Message", "SMTP Direct Message Processing"), contexts);
            }
            LOGGER.debug((Object)("Sending incoming message from " + envelope.getSender().toString() + " to STAgent"));
        }
        processedMessage = isOutgoing ? this.agent.processOutgoing(envelope) : this.agent.processIncoming(envelope);
        return processedMessage;
    }

    private void postProcessMessage(MessageProcessResult result) {
        boolean isOutgoing = result.getProcessedMessage() instanceof OutgoingMessage;
        if (this.auditor != null && result.getProcessedMessage().getRejectedRecipients() != null && result.getProcessedMessage().getRejectedRecipients().size() > 0) {
            Collection<AuditContext> contexts = this.createContextCollectionFromMessage(result.getProcessedMessage(), Arrays.asList(AuditEvents.DEFAULT_HEADER_CONTEXT));
            StringBuffer rejectedRecips = new StringBuffer();
            int cnt = 0;
            for (NHINDAddress address : result.getProcessedMessage().getRejectedRecipients()) {
                rejectedRecips.append(address.getAddress());
                if (++cnt >= result.getProcessedMessage().getRejectedRecipients().size()) continue;
                rejectedRecips.append(", ");
            }
            contexts.add((AuditContext)new DefaultAuditContext("Rejected Recipients", rejectedRecips.toString()));
            this.auditor.audit(PRINICPAL, new AuditEvent("Rejected Direct Message Recipients", "SMTP Direct Message Processing"), contexts);
        }
        if (isOutgoing) {
            this.postProcessOutgoingMessage(result);
        } else {
            this.postProcessIncomingMessage(result);
        }
    }

    private void postProcessOutgoingMessage(MessageProcessResult result) {
        if (result.getProcessedMessage().hasRecipients()) {
            this.copyMessage((MimeMessage)result.getProcessedMessage().getMessage(), this.settings.getOutgoingMessageSettings());
        }
    }

    private void postProcessIncomingMessage(MessageProcessResult result) {
        this.copyMessage((MimeMessage)result.getProcessedMessage().getMessage(), this.settings.getIncomingMessageSettings());
        try {
            if (this.settings.getNotificationProducer() != null) {
                result.setNotificationMessages(this.settings.getNotificationProducer().produce((IncomingMessage)result.getProcessedMessage()));
                if (result.getNotificationMessages() != null && this.auditor != null) {
                    for (NotificationMessage noteMsg : result.getNotificationMessages()) {
                        Collection<AuditContext> contexts = this.createContextCollectionFromMessage((Message)noteMsg, Arrays.asList(AuditEvents.MDN_HEADER_CONTEXT));
                        this.auditor.audit(PRINICPAL, new AuditEvent("Produce Direct MDN Message", "SMTP Direct Message Processing"), contexts);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to create notification messages.", (Throwable)e);
        }
        if (NotificationHelper.isMDN((Message)result.getProcessedMessage().getMessage())) {
            Collection<AuditContext> contexts = this.createContextCollectionFromMessage(result.getProcessedMessage(), Arrays.asList(AuditEvents.MDN_RECEIVED_CONTEXT));
            this.auditor.audit(PRINICPAL, new AuditEvent("Received Direct MDN Message", "SMTP Direct Message Processing"), contexts);
        }
    }

    private void copyMessage(MimeMessage message, MessageProcessingSettings settings) {
        if (settings != null && settings.hasSaveMessageFolder()) {
            File fl = new File(settings.getSaveMessageFolder().getAbsolutePath() + File.separator + this.generateUniqueFileName());
            try {
                FileUtils.writeStringToFile((File)fl, (String)EntitySerializer.Default.serialize((MimePart)message));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private String generateUniqueFileName() {
        return UUID.randomUUID().toString() + ".eml";
    }

    private Collection<AuditContext> createContextCollectionFromMessage(Message msg, Collection<String> headers) {
        return this.createContextCollectionFromMessage((MessageEnvelope)new DefaultMessageEnvelope(msg), headers);
    }

    private Collection<AuditContext> createContextCollectionFromMessage(MessageEnvelope env, Collection<String> headers) {
        ArrayList<AuditContext> retVal = new ArrayList<AuditContext>();
        for (String header : headers) {
            try {
                String theHeader = null;
                if (header.equals("from")) {
                    theHeader = env.getSender().getAddress();
                } else if (header.equals("Disposition") || header.equals("Original-Message-ID") || header.equals("Final-Recipient")) {
                    Message msg = env.getMessage();
                    InternetHeaders notHeaders = null;
                    try {
                        notHeaders = Notification.getNotificationFieldsAsHeaders((MimeMessage)msg);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    theHeader = notHeaders != null ? notHeaders.getHeader(header, ",") : msg.getHeader(header, ",");
                } else {
                    theHeader = env.getMessage().getHeader(header, ",");
                }
                if (theHeader == null || theHeader.isEmpty()) continue;
                retVal.add((AuditContext)new DefaultAuditContext(header, theHeader));
            }
            catch (MessagingException e) {
                LOGGER.warn((Object)("Error retrieving header " + header + " from the message."));
            }
        }
        return retVal;
    }

    static {
        String host = "";
        try {
            host = InetAddress.getLocalHost().getHostName();
            host = "@" + host;
        }
        catch (UnknownHostException e) {
            LOGGER.warn((Object)("Coulnd not get host name: " + e.getMessage()));
        }
        PRINICPAL = "STAgent" + host;
    }
}

