/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.config;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.nhind.config.Anchor;
import org.nhind.config.ConfigurationService;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.Domain;
import org.nhind.config.Setting;
import org.nhindirect.config.service.impl.ConfigurationServiceImplServiceSoapBindingStub;
import org.nhindirect.gateway.smtp.DomainPostmaster;
import org.nhindirect.gateway.smtp.MessageProcessingSettings;
import org.nhindirect.gateway.smtp.NotificationProducer;
import org.nhindirect.gateway.smtp.NotificationSettings;
import org.nhindirect.gateway.smtp.ProcessBadMessageSettings;
import org.nhindirect.gateway.smtp.ProcessIncomingSettings;
import org.nhindirect.gateway.smtp.ProcessOutgoingSettings;
import org.nhindirect.gateway.smtp.RawMessageSettings;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.SmtpAgentError;
import org.nhindirect.gateway.smtp.SmtpAgentException;
import org.nhindirect.gateway.smtp.SmtpAgentSettings;
import org.nhindirect.gateway.smtp.config.SmtpAgentConfig;
import org.nhindirect.gateway.smtp.config.cert.impl.ConfigServiceCertificateStore;
import org.nhindirect.gateway.smtp.config.cert.impl.provider.ConfigServiceCertificateStoreProvider;
import org.nhindirect.gateway.smtp.module.SmtpAgentModule;
import org.nhindirect.gateway.smtp.provider.DefaultSmtpAgentProvider;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.impl.DNSCertificateStore;
import org.nhindirect.stagent.cert.impl.EmployLdapAuthInformation;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapStoreConfiguration;
import org.nhindirect.stagent.cert.impl.provider.DNSCertStoreProvider;
import org.nhindirect.stagent.cert.impl.provider.KeyStoreCertificateStoreProvider;
import org.nhindirect.stagent.cert.impl.provider.LdapCertificateStoreProvider;
import org.nhindirect.stagent.cert.impl.provider.PublicLdapCertificateStoreProvider;
import org.nhindirect.stagent.module.AgentModule;
import org.nhindirect.stagent.module.PrivateCertStoreModule;
import org.nhindirect.stagent.module.PublicCertStoreModule;
import org.nhindirect.stagent.module.TrustAnchorModule;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;
import org.nhindirect.stagent.trust.provider.MultiDomainTrustAnchorResolverProvider;
import org.nhindirect.stagent.trust.provider.UniformTrustAnchorResolverProvider;

public class WSSmtpAgentConfig
implements SmtpAgentConfig {
    protected static final String STORE_TYPE_WS = "WS";
    protected static final String STORE_TYPE_LDAP = "LDAP";
    protected static final String STORE_TYPE_PUBLIC_LDAP = "PublicLDAP";
    protected static final String STORE_TYPE_KEYSTORE = "keystore";
    protected static final String STORE_TYPE_DNS = "DNS";
    protected static final String ANCHOR_RES_TYPE_UNIFORM = "uniform";
    protected static final String ANCHOR_RES_TYPE_MULTIDOMAIN = "multidomain";
    protected static final String MESSAGE_SETTING_RAW = "Raw";
    protected static final String MESSAGE_SETTING_INCOMING = "Incoming";
    protected static final String MESSAGE_SETTING_OUTGOING = "Outgoing";
    protected static final String MESSAGE_SETTING_BAD = "Bad";
    protected Collection<String> domains;
    protected Map<String, DomainPostmaster> domainPostmasters;
    @Inject(optional=true)
    protected Provider<SmtpAgent> smtpAgentProvider;
    @Inject
    protected Provider<NHINDAgent> agentProvider;
    protected Module certAnchorModule;
    protected Module publicCertModule;
    protected Module privateCertModule;
    protected RawMessageSettings rawSettings;
    protected ProcessIncomingSettings incomingSettings;
    protected ProcessOutgoingSettings outgoingSettings;
    protected ProcessBadMessageSettings badSettings;
    protected NotificationProducer notificationProducer;
    protected final ConfigurationServiceProxy cfService;

    protected X509Certificate certFromData(byte[] data) throws SmtpAgentException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
        }
        catch (CertificateException e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "Invalid certificate data: " + e.getMessage(), e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException e) {}
        }
        return cert;
    }

    public WSSmtpAgentConfig(URL configServiceLocation, Provider<NHINDAgent> agentProvider) {
        this.agentProvider = agentProvider;
        this.cfService = new ConfigurationServiceProxy(configServiceLocation.toExternalForm());
        ConfigurationService internalService = this.cfService.getConfigurationService();
        if (internalService != null && internalService instanceof ConfigurationServiceImplServiceSoapBindingStub) {
            ConfigServiceCertificateStore.initJVMParams();
            OptionsParameter param = OptionsManager.getInstance().getParameter("WS_CERT_RESOLVER_CONNECTION_TIMEOUT");
            int connectionTimeOut = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)30000);
            ((ConfigurationServiceImplServiceSoapBindingStub)internalService).setTimeout(connectionTimeOut);
        }
    }

    @Override
    public synchronized Injector getAgentInjector() {
        return this.buildAgentInjector();
    }

    protected Injector buildAgentInjector() {
        this.buildDomains();
        this.buildPublicCertStore();
        this.buildPrivateCertStore();
        this.buildMDNSettings();
        this.buildMessageSettings(MESSAGE_SETTING_RAW);
        this.buildMessageSettings(MESSAGE_SETTING_INCOMING);
        this.buildMessageSettings(MESSAGE_SETTING_OUTGOING);
        this.buildMessageSettings(MESSAGE_SETTING_BAD);
        SmtpAgentSettings settings = new SmtpAgentSettings(this.domainPostmasters, this.rawSettings, this.outgoingSettings, this.incomingSettings, this.badSettings, this.notificationProducer);
        if (this.smtpAgentProvider == null) {
            this.smtpAgentProvider = new DefaultSmtpAgentProvider(settings);
        }
        AgentModule agentModule = this.agentProvider == null ? AgentModule.create(this.domains, (Module)this.publicCertModule, (Module)this.privateCertModule, (Module)this.certAnchorModule) : AgentModule.create(this.agentProvider);
        return Guice.createInjector((Module[])new Module[]{agentModule, SmtpAgentModule.create(this.smtpAgentProvider)});
    }

    protected void buildDomains() {
        this.domains = new ArrayList<String>();
        this.domainPostmasters = new HashMap<String, DomainPostmaster>();
        Domain[] lookedupDomains = null;
        try {
            int domainCount = this.cfService.getDomainCount();
            lookedupDomains = this.cfService.listDomains(null, domainCount);
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting domains list: " + e.getMessage(), e);
        }
        if (lookedupDomains != null) {
            for (Domain dom : lookedupDomains) {
                this.domains.add(dom.getDomainName());
                try {
                    String configuredAddress = dom.getPostMasterEmail();
                    configuredAddress = configuredAddress == null || configuredAddress.trim().isEmpty() ? DomainPostmaster.getDefaultPostmaster(dom.getDomainName()) : configuredAddress;
                    this.domainPostmasters.put(dom.getDomainName().toUpperCase(Locale.getDefault()), new DomainPostmaster(dom.getDomainName(), new InternetAddress(configuredAddress)));
                }
                catch (AddressException e) {
                    // empty catch block
                }
            }
        }
        if (this.domains.size() == 0) {
            throw new SmtpAgentException(SmtpAgentError.MissingDomains);
        }
        this.buildTrustAnchorResolver();
    }

    public void buildTrustAnchorResolver() {
        MultiDomainTrustAnchorResolverProvider provider = null;
        HashMap<String, Collection<X509Certificate>> incomingAnchors = new HashMap<String, Collection<X509Certificate>>();
        HashMap<String, Collection<X509Certificate>> outgoingAnchors = new HashMap<String, Collection<X509Certificate>>();
        Setting setting = null;
        try {
            setting = this.cfService.getSettingByName("AnchorStoreType");
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting anchor store type: " + e.getMessage(), e);
        }
        String storeType = setting == null || setting.getValue() == null || setting.getValue().isEmpty() ? STORE_TYPE_WS : setting.getValue();
        if (!storeType.equalsIgnoreCase(STORE_TYPE_WS)) {
            this.getAnchorsFromNonWS(incomingAnchors, outgoingAnchors, storeType);
        } else {
            for (String domain : this.domains) {
                try {
                    Anchor[] anchors = this.cfService.getAnchorsForOwner(domain, null);
                    if (anchors == null || anchors.length <= 0) continue;
                    ArrayList<X509Certificate> incomingAnchorsToAdd = new ArrayList<X509Certificate>();
                    ArrayList<X509Certificate> outgoingAnchorsToAdd = new ArrayList<X509Certificate>();
                    for (Anchor anchor : anchors) {
                        X509Certificate anchorToAdd = this.certFromData(anchor.getData());
                        if (anchor.isIncoming()) {
                            incomingAnchorsToAdd.add(anchorToAdd);
                        }
                        if (!anchor.isOutgoing()) continue;
                        outgoingAnchorsToAdd.add(anchorToAdd);
                    }
                    incomingAnchors.put(domain, incomingAnchorsToAdd);
                    outgoingAnchors.put(domain, outgoingAnchorsToAdd);
                }
                catch (SmtpAgentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SmtpAgentException(SmtpAgentError.InvalidTrustAnchorSettings, "WebService error getting trust anchors for domain " + domain + ":" + e.getMessage(), e);
                }
            }
        }
        try {
            setting = this.cfService.getSettingByName("AnchorResolverType");
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting anchor resolver type: " + e.getMessage(), e);
        }
        if (incomingAnchors.size() == 0 && outgoingAnchors.size() == 0) {
            throw new SmtpAgentException(SmtpAgentError.InvalidTrustAnchorSettings, "No trust anchors defined.");
        }
        String resolverType = setting == null || setting.getValue() == null || setting.getValue().isEmpty() ? ANCHOR_RES_TYPE_MULTIDOMAIN : setting.getValue();
        if (resolverType.equalsIgnoreCase(ANCHOR_RES_TYPE_UNIFORM)) {
            provider = incomingAnchors.size() > 0 ? new UniformTrustAnchorResolverProvider((Collection)incomingAnchors.values().iterator().next()) : new UniformTrustAnchorResolverProvider((Collection)outgoingAnchors.values().iterator().next());
        } else if (resolverType.equalsIgnoreCase(ANCHOR_RES_TYPE_MULTIDOMAIN)) {
            provider = new MultiDomainTrustAnchorResolverProvider(incomingAnchors, outgoingAnchors);
        } else {
            throw new SmtpAgentException(SmtpAgentError.InvalidTrustAnchorSettings);
        }
        this.certAnchorModule = TrustAnchorModule.create((Provider)provider);
    }

    protected void getAnchorsFromNonWS(Map<String, Collection<X509Certificate>> incomingAnchors, Map<String, Collection<X509Certificate>> outgoingAnchors, String storeType) {
        block18: {
            Setting[] outgoingAliasSettings;
            Setting[] incomingAliasSettings;
            block17: {
                X509Certificate cert;
                String[] aliases;
                ArrayList<X509Certificate> certs;
                Setting privKeyPass;
                Setting pass;
                Setting file;
                ArrayList<String> incomingLookups = new ArrayList<String>();
                ArrayList<String> outgoingLookups = new ArrayList<String>();
                for (String domain : this.domains) {
                    incomingLookups.add(domain + "IncomingAnchorAliases");
                    outgoingLookups.add(domain + "OutgoingAnchorAliases");
                }
                try {
                    incomingAliasSettings = this.cfService.getSettingsByNames(incomingLookups.toArray(new String[incomingLookups.size()]));
                    outgoingAliasSettings = this.cfService.getSettingsByNames(outgoingLookups.toArray(new String[outgoingLookups.size()]));
                }
                catch (Exception e) {
                    throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting anchor aliases: " + e.getMessage(), e);
                }
                if (!storeType.equalsIgnoreCase(STORE_TYPE_KEYSTORE)) break block17;
                try {
                    file = this.cfService.getSettingByName("AnchorKeyStoreFile");
                    pass = this.cfService.getSettingByName("AnchorKeyStoreFilePass");
                    privKeyPass = this.cfService.getSettingByName("AnchorKeyStorePrivKeyPass");
                }
                catch (Exception e) {
                    throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting anchor key store settings: " + e.getMessage(), e);
                }
                KeyStoreCertificateStore store = new KeyStoreCertificateStore(file == null ? null : file.getValue(), pass == null ? "DefaultFilePass" : pass.getValue(), privKeyPass == null ? "DefaultKeyPass" : privKeyPass.getValue());
                if (incomingAliasSettings != null) {
                    for (Setting setting : incomingAliasSettings) {
                        certs = new ArrayList<X509Certificate>();
                        for (String alias : aliases = setting.getValue().split(",")) {
                            cert = store.getByAlias(alias);
                            if (cert == null) continue;
                            certs.add(cert);
                        }
                        incomingAnchors.put(setting.getName().substring(0, setting.getName().lastIndexOf("IncomingAnchorAliases")), certs);
                    }
                }
                if (outgoingAliasSettings == null) break block18;
                for (Setting setting : outgoingAliasSettings) {
                    certs = new ArrayList();
                    for (String alias : aliases = setting.getValue().split(",")) {
                        cert = store.getByAlias(alias);
                        if (cert == null) continue;
                        certs.add(cert);
                    }
                    outgoingAnchors.put(setting.getName().substring(0, setting.getName().lastIndexOf("OutgoingAnchorAliases")), certs);
                }
                break block18;
            }
            if (storeType.equalsIgnoreCase(STORE_TYPE_LDAP)) {
                String[] aliases;
                ArrayList certs;
                LDAPCertificateStore ldapCertificateStore = (LDAPCertificateStore)this.buildLdapCertificateStoreProvider("TrustAnchor", "LDAPTrustAnchorStore").get();
                if (incomingAliasSettings != null) {
                    for (Setting setting : incomingAliasSettings) {
                        certs = new ArrayList();
                        for (String alias : aliases = setting.getValue().split(",")) {
                            certs.addAll(ldapCertificateStore.getCertificates(alias));
                        }
                        incomingAnchors.put(setting.getName().substring(0, setting.getName().lastIndexOf("IncomingAnchorAliases")), certs);
                    }
                }
                if (outgoingAliasSettings != null) {
                    for (Setting setting : outgoingAliasSettings) {
                        certs = new ArrayList();
                        for (String alias : aliases = setting.getValue().split(",")) {
                            certs.addAll(ldapCertificateStore.getCertificates(alias));
                        }
                        outgoingAnchors.put(setting.getName().substring(0, setting.getName().lastIndexOf("OutgoingAnchorAliases")), certs);
                    }
                }
            }
        }
    }

    protected LdapCertificateStoreProvider buildLdapCertificateStoreProvider(String type, String cacheStoreName) {
        String ldapCertPassphrase;
        Setting ldapCertPassphraseSetting;
        Setting ldapConnTimeoutSetting;
        Setting ldapPasswordSetting;
        Setting ldapUserSetting;
        Setting ldapCertFormatSetting;
        Setting ldapCertAttrSetting;
        Setting ldapSearchAttrSetting;
        Setting ldapSearchBaseSetting;
        Setting ldapURLSetting;
        try {
            ldapURLSetting = this.cfService.getSettingByName(type + "LDAPUrl");
            ldapSearchBaseSetting = this.cfService.getSettingByName(type + "LDAPSearchBase");
            ldapSearchAttrSetting = this.cfService.getSettingByName(type + "LDAPSearchAttr");
            ldapCertAttrSetting = this.cfService.getSettingByName(type + "LDAPCertAttr");
            ldapCertFormatSetting = this.cfService.getSettingByName(type + "LDAPCertFormat");
            ldapUserSetting = this.cfService.getSettingByName(type + "LDAPUser");
            ldapPasswordSetting = this.cfService.getSettingByName(type + "LDAPPassword");
            ldapConnTimeoutSetting = this.cfService.getSettingByName(type + "LDAPConnTimeout");
            ldapCertPassphraseSetting = this.cfService.getSettingByName(type + "LDAPCertPassphrase");
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting LDAP store settings: " + e.getMessage(), e);
        }
        if (ldapURLSetting == null || ldapURLSetting.getValue() == null || ldapURLSetting.getValue().isEmpty()) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "Missing LDAP URL");
        }
        String ldapSearchBase = ldapSearchBaseSetting == null ? null : ldapSearchBaseSetting.getValue();
        String ldapSearchAttr = ldapSearchAttrSetting == null ? null : ldapSearchAttrSetting.getValue();
        String ldapCertAttr = ldapCertAttrSetting == null ? null : ldapCertAttrSetting.getValue();
        String ldapCertFormat = ldapCertFormatSetting == null ? null : ldapCertFormatSetting.getValue();
        String[] ldapURL = ldapURLSetting.getValue().split(",");
        if (ldapURL[0].isEmpty() || ldapSearchBase.isEmpty() || ldapSearchAttr.isEmpty() || ldapCertAttr.isEmpty() || ldapCertFormat.isEmpty()) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "Missing required LDAP parameters.");
        }
        String ldapUser = ldapUserSetting == null ? null : ldapUserSetting.getValue();
        String ldapPassword = ldapPasswordSetting == null ? null : ldapPasswordSetting.getValue();
        String ldapConnTimeout = ldapConnTimeoutSetting == null ? null : ldapConnTimeoutSetting.getValue();
        String string = ldapCertPassphrase = ldapCertPassphraseSetting == null ? null : ldapCertPassphraseSetting.getValue();
        if (ldapCertFormat.equalsIgnoreCase("pkcs12") && (ldapCertPassphrase == null || ldapCertPassphrase.isEmpty())) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat);
        }
        LdapStoreConfiguration ldapStoreConfiguration = new LdapStoreConfiguration(ldapURL, ldapSearchBase, ldapSearchAttr, ldapCertAttr, ldapCertFormat);
        if (ldapUser != null && !ldapUser.isEmpty() && ldapPassword != null && !ldapPassword.isEmpty()) {
            ldapStoreConfiguration.setEmployLdapAuthInformation(new EmployLdapAuthInformation(ldapUser, ldapPassword));
        }
        if (ldapConnTimeout != null && !ldapConnTimeout.isEmpty()) {
            ldapStoreConfiguration.setLdapConnectionTimeOut(ldapConnTimeout);
        }
        if (ldapCertPassphrase != null && !ldapCertPassphrase.isEmpty()) {
            ldapStoreConfiguration.setLdapCertPassphrase(ldapCertPassphrase);
        }
        LdapCertificateStoreProvider ldapCertificateStoreProvider = new LdapCertificateStoreProvider(ldapStoreConfiguration, null, (CertStoreCachePolicy)new LDAPCertificateStore.DefaultLDAPCachePolicy());
        return ldapCertificateStoreProvider;
    }

    protected void buildPublicCertStore() {
        String[] types;
        Object resolverProvider = null;
        ArrayList<DNSCertStoreProvider> resolverProviders = new ArrayList<DNSCertStoreProvider>();
        Setting setting = null;
        try {
            setting = this.cfService.getSettingByName("PublicStoreType");
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting public store type: " + e.getMessage(), e);
        }
        String storeTypes = setting == null || setting.getValue() == null || setting.getValue().isEmpty() ? "DNS,PublicLDAP" : setting.getValue();
        for (String storeType : types = storeTypes.split(",")) {
            if (storeType.equalsIgnoreCase(STORE_TYPE_KEYSTORE)) {
                Setting privKeyPass;
                Setting pass;
                Setting file;
                try {
                    file = this.cfService.getSettingByName("PublicStoreFile");
                    pass = this.cfService.getSettingByName("PublicStoreFilePass");
                    privKeyPass = this.cfService.getSettingByName("PublicStorePrivKeyPass");
                }
                catch (Exception e) {
                    throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting public store file settings: " + e.getMessage(), e);
                }
                resolverProvider = new KeyStoreCertificateStoreProvider(file == null ? "PublicStoreKeyFile" : file.getValue(), pass == null ? "DefaultFilePass" : pass.getValue(), privKeyPass == null ? "DefaultKeyPass" : privKeyPass.getValue());
            } else {
                resolverProvider = storeType.equalsIgnoreCase(STORE_TYPE_DNS) ? new DNSCertStoreProvider((Collection)Collections.EMPTY_LIST, null, (CertStoreCachePolicy)new DNSCertificateStore.DefaultDNSCachePolicy()) : (storeType.equalsIgnoreCase(STORE_TYPE_WS) ? new ConfigServiceCertificateStoreProvider(this.cfService, null, new ConfigServiceCertificateStore.DefaultConfigStoreCachePolicy()) : (storeType.equalsIgnoreCase(STORE_TYPE_PUBLIC_LDAP) ? new PublicLdapCertificateStoreProvider(null, (CertStoreCachePolicy)new LDAPCertificateStore.DefaultLDAPCachePolicy()) : new DNSCertStoreProvider((Collection)Collections.EMPTY_LIST, null, (CertStoreCachePolicy)new DNSCertificateStore.DefaultDNSCachePolicy())));
            }
            resolverProviders.add((DNSCertStoreProvider)resolverProvider);
        }
        this.publicCertModule = new PublicCertStoreModule(resolverProviders);
    }

    protected void buildPrivateCertStore() {
        Object resolverProvider = null;
        Setting setting = null;
        try {
            setting = this.cfService.getSettingByName("PrivateStoreType");
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting public store type: " + e.getMessage(), e);
        }
        String storeType = setting == null || setting.getValue() == null || setting.getValue().isEmpty() ? STORE_TYPE_WS : setting.getValue();
        if (storeType.equalsIgnoreCase(STORE_TYPE_KEYSTORE)) {
            Setting privKeyPass;
            Setting pass;
            Setting file;
            try {
                file = this.cfService.getSettingByName("PrivateStoreFile");
                pass = this.cfService.getSettingByName("PrivateStoreFilePass");
                privKeyPass = this.cfService.getSettingByName("PrivateStorePrivKeyPass");
            }
            catch (Exception e) {
                throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting private store file settings: " + e.getMessage(), e);
            }
            resolverProvider = new KeyStoreCertificateStoreProvider(file == null ? null : file.getValue(), pass == null ? null : pass.getValue(), privKeyPass == null ? null : privKeyPass.getValue());
        } else if (storeType.equalsIgnoreCase(STORE_TYPE_LDAP)) {
            resolverProvider = this.buildLdapCertificateStoreProvider("PrivateStore", "LDAPPrivateCertStore");
        } else if (storeType.equalsIgnoreCase(STORE_TYPE_WS)) {
            resolverProvider = new ConfigServiceCertificateStoreProvider(this.cfService, null, new ConfigServiceCertificateStore.DefaultConfigStoreCachePolicy());
        } else {
            throw new SmtpAgentException(SmtpAgentError.InvalidPrivateCertStoreSettings);
        }
        this.privateCertModule = new PrivateCertStoreModule((Provider)resolverProvider);
    }

    protected void buildMDNSettings() {
        Setting textSetting;
        Setting prodNameSetting;
        Setting autoResponseSettings;
        try {
            autoResponseSettings = this.cfService.getSettingByName("MDNAutoResponse");
            prodNameSetting = this.cfService.getSettingByName("MDNProdName");
            textSetting = this.cfService.getSettingByName("MDNText");
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting MDN settings: " + e.getMessage(), e);
        }
        boolean autoResponse = autoResponseSettings == null ? true : Boolean.parseBoolean(autoResponseSettings.getValue());
        String prodName = prodNameSetting == null ? "" : prodNameSetting.getValue();
        String text = textSetting == null ? "" : textSetting.getValue();
        this.notificationProducer = new NotificationProducer(new NotificationSettings(autoResponse, prodName, text));
    }

    protected void buildMessageSettings(String type) {
        Setting folderSettings;
        try {
            folderSettings = this.cfService.getSettingByName(type + "MessageSaveFolder");
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, "WebService error getting " + type + " message settings: " + e.getMessage(), e);
        }
        String saveFolder = folderSettings == null ? null : folderSettings.getValue();
        MessageProcessingSettings settings = null;
        if (type.equalsIgnoreCase(MESSAGE_SETTING_RAW)) {
            settings = this.rawSettings = new RawMessageSettings();
        } else if (type.equalsIgnoreCase(MESSAGE_SETTING_INCOMING)) {
            this.incomingSettings = new ProcessIncomingSettings();
            settings = this.incomingSettings;
        } else if (type.equalsIgnoreCase(MESSAGE_SETTING_OUTGOING)) {
            this.outgoingSettings = new ProcessOutgoingSettings();
            settings = this.outgoingSettings;
        } else if (type.equalsIgnoreCase(MESSAGE_SETTING_BAD)) {
            this.badSettings = new ProcessBadMessageSettings();
            settings = this.badSettings;
        }
        if (saveFolder != null && settings != null) {
            settings.setSaveMessageFolder(new File(saveFolder));
        }
    }
}

