/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.config.cert.impl;

import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CacheableCertStore;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class ConfigServiceCertificateStore
extends CertificateStore
implements CacheableCertStore {
    public static final String WS_CERT_RESOLVER_MAX_CACHE_SIZE = "WS_CERT_RESOLVER_MAX_CACHE_SIZE";
    public static final String WS_CERT_RESOLVER_CACHE_TTL = "WS_CERT_RESOLVER_CACHE_TTL";
    public static final String WS_CERT_RESOLVER_SO_TIMEOUT = "WS_CERT_RESOLVER_SO_TIMEOUT";
    public static final String WS_CERT_RESOLVER_CONNECTION_TIMEOUT = "WS_CERT_RESOLVER_CONNECTION_TIMEOUT";
    public static final int DEFAULT_WS_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_WS_SO_TIMEOUT = 10000;
    protected static final int DEFAULT_WS_MAX_CAHCE_ITEMS = 1000;
    protected static final int DEFAULT_WS_TTL = 3600;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(ConfigServiceCertificateStore.class);
    private static final String CACHE_NAME = "CONFIG_SERVICE_CERT_CACHE";
    protected CertificateStore localStoreDelegate;
    protected JCS cache;
    protected CertStoreCachePolicy cachePolicy;
    protected ConfigurationServiceProxy proxy;

    public static synchronized void initJVMParams() {
        HashMap<String, String> JVM_PARAMS = new HashMap<String, String>();
        JVM_PARAMS.put(WS_CERT_RESOLVER_MAX_CACHE_SIZE, "org.nhindirect.stagent.cert.wsresolver.MaxCacheSize");
        JVM_PARAMS.put(WS_CERT_RESOLVER_SO_TIMEOUT, "org.nhindirect.stagent.cert.wsresolver.SOTimeout");
        JVM_PARAMS.put(WS_CERT_RESOLVER_CACHE_TTL, "org.nhindirect.stagent.cert.wsresolver.CacheTTL");
        JVM_PARAMS.put(WS_CERT_RESOLVER_CONNECTION_TIMEOUT, "org.nhindirect.stagent.cert.wsresolver.ConnectionTimeout");
        OptionsManager.addInitParameters(JVM_PARAMS);
    }

    public ConfigServiceCertificateStore(ConfigurationServiceProxy proxy) {
        this.setConfigurationServiceProxy(proxy);
        this.createCache();
    }

    public ConfigServiceCertificateStore(ConfigurationServiceProxy proxy, CertificateStore bootstrapStore, CertStoreCachePolicy policy) {
        this.cachePolicy = policy;
        this.createCache();
        if (bootstrapStore != null) {
            this.localStoreDelegate = bootstrapStore;
            this.loadBootStrap();
        }
        this.setConfigurationServiceProxy(proxy);
    }

    public void setConfigurationServiceProxy(ConfigurationServiceProxy proxy) {
        this.proxy = proxy;
    }

    protected synchronized JCS getCache() {
        if (this.cache == null) {
            this.createCache();
        }
        return this.cache;
    }

    private void createCache() {
        try {
            this.cache = CertCacheFactory.getInstance().getCertCache(CACHE_NAME, this.cachePolicy == null ? this.getDefaultPolicy() : this.cachePolicy);
            if (this.cachePolicy == null) {
                this.cachePolicy = this.getDefaultPolicy();
            }
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    private void applyCachePolicy(CertStoreCachePolicy policy) {
        if (this.getCache() != null) {
            try {
                ICompositeCacheAttributes attributes = this.cache.getCacheAttributes();
                attributes.setMaxObjects(policy.getMaxItems());
                attributes.setUseLateral(false);
                attributes.setUseRemote(false);
                this.cache.setCacheAttributes(attributes);
                IElementAttributes eattributes = this.cache.getDefaultElementAttributes();
                eattributes.setMaxLifeSeconds((long)policy.getSubjectTTL());
                eattributes.setIsEternal(false);
                eattributes.setIsLateral(false);
                eattributes.setIsRemote(false);
                this.cache.setDefaultElementAttributes(eattributes);
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    private CertStoreCachePolicy getDefaultPolicy() {
        return new DefaultConfigStoreCachePolicy();
    }

    public boolean contains(X509Certificate cert) {
        throw new UnsupportedOperationException("Contains is not supported.");
    }

    public void add(X509Certificate cert) {
        throw new UnsupportedOperationException("Add is not supported.");
    }

    public void remove(X509Certificate cert) {
        throw new UnsupportedOperationException("Remove is not supported.");
    }

    public Collection<X509Certificate> getCertificates(String subjectName) {
        Collection retVal;
        int index = subjectName.indexOf("EMAILADDRESS=");
        String realSubjectName = index > -1 ? subjectName.substring(index + "EMAILADDRESS=".length()) : subjectName;
        JCS cache = this.getCache();
        if (cache != null) {
            retVal = (Collection)cache.get((Object)realSubjectName);
            if (!(retVal != null && retVal.size() != 0 || (retVal = this.lookupFromConfigStore(realSubjectName)) != null && retVal.size() != 0)) {
                LOGGER.info((Object)("getCertificates(String subjectName) - Could not find a ConfigService certificate for subject " + subjectName));
            }
        } else {
            retVal = this.lookupFromConfigStore(realSubjectName);
            if (retVal.size() == 0) {
                if (this.localStoreDelegate != null) {
                    retVal = this.localStoreDelegate.getCertificates(realSubjectName);
                    if (retVal == null || retVal.size() == 0) {
                        LOGGER.info((Object)("getCertificates(String subjectName) - Could not find a ConfigService certificate for subject " + subjectName));
                    }
                } else {
                    LOGGER.info((Object)("getCertificates(String subjectName) - Could not find a ConfigService certificate for subject " + subjectName));
                }
            }
        }
        return retVal;
    }

    private Collection<X509Certificate> lookupFromConfigStore(String subjectName) {
        Certificate[] certificates;
        try {
            certificates = this.proxy.getCertificatesForOwner(subjectName, null);
        }
        catch (Exception e) {
            throw new NHINDException("WebService error getting certificates by subject: " + e.getMessage(), e);
        }
        if (certificates == null || certificates.length == 0) {
            int index = subjectName.indexOf("@");
            String domain = index > -1 ? subjectName.substring(index + 1) : subjectName;
            try {
                certificates = this.proxy.getCertificatesForOwner(domain, null);
            }
            catch (Exception e) {
                throw new NHINDException("WebService error getting certificates by domain: " + e.getMessage(), e);
            }
        }
        if (certificates == null || certificates.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate> retVal = new ArrayList<X509Certificate>();
        for (Certificate cert : certificates) {
            X509Certificate storeCert = this.certFromData(cert.getData());
            retVal.add(storeCert);
            if (this.localStoreDelegate == null) continue;
            if (this.localStoreDelegate.contains(storeCert)) {
                this.localStoreDelegate.update(storeCert);
                continue;
            }
            this.localStoreDelegate.add(storeCert);
        }
        try {
            if (this.cache != null) {
                this.cache.put((Object)subjectName, retVal);
            }
        }
        catch (CacheException e) {
            // empty catch block
        }
        return retVal;
    }

    public Collection<X509Certificate> getAllCertificates() {
        Certificate[] certificates;
        try {
            certificates = this.proxy.listCertificates(0L, 36863, null);
        }
        catch (Exception e) {
            throw new NHINDException("WebService error getting all certificates: " + e.getMessage(), e);
        }
        this.flush(true);
        if (certificates == null || certificates.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate> retVal = new ArrayList<X509Certificate>();
        for (Certificate cert : certificates) {
            X509Certificate storeCert = this.certFromData(cert.getData());
            retVal.add(storeCert);
            try {
                if (this.cache != null) {
                    this.cache.put((Object)cert.getOwner(), retVal);
                }
            }
            catch (CacheException e) {
                // empty catch block
            }
            if (this.localStoreDelegate == null) continue;
            if (this.localStoreDelegate.contains(storeCert)) {
                this.localStoreDelegate.update(storeCert);
                continue;
            }
            this.localStoreDelegate.add(storeCert);
        }
        return retVal;
    }

    private X509Certificate certFromData(byte[] data) {
        X509Certificate retVal = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, "".toCharArray());
                    retVal = key != null && key instanceof PrivateKey ? X509CertificateEx.fromX509Certificate((X509Certificate)cert, (PrivateKey)((PrivateKey)key)) : cert;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (retVal == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new NHINDException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return retVal;
    }

    public void flush(boolean purgeBootStrap) {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
            if (purgeBootStrap && this.localStoreDelegate != null) {
                this.localStoreDelegate.remove(this.localStoreDelegate.getAllCertificates());
            }
        }
    }

    public void loadBootStrap() {
        if (this.localStoreDelegate == null) {
            throw new IllegalStateException("The boot strap store has not been set.");
        }
        JCS cache = null;
        cache = this.getCache();
        if (cache != null) {
            HashMap cacheBuilderMap = new HashMap();
            for (X509Certificate x509Certificate : this.localStoreDelegate.getAllCertificates()) {
            }
            for (Map.Entry entry : cacheBuilderMap.entrySet()) {
                try {
                    cache.put(entry.getKey(), entry.getValue());
                }
                catch (CacheException e) {}
            }
        }
    }

    public void loadBootStrap(CertificateStore bootstrapStore) {
        if (bootstrapStore == null) {
            throw new IllegalArgumentException();
        }
        this.localStoreDelegate = bootstrapStore;
        this.loadBootStrap();
    }

    public void setBootStrap(CertificateStore bootstrapStore) {
        this.loadBootStrap(bootstrapStore);
    }

    public void setCachePolicy(CertStoreCachePolicy policy) {
        this.cachePolicy = policy;
        this.applyCachePolicy(policy);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ConfigServiceCertificateStore.initJVMParams();
    }

    public static class DefaultConfigStoreCachePolicy
    implements CertStoreCachePolicy {
        protected final int maxItems;
        protected final int subjectTTL;

        public DefaultConfigStoreCachePolicy() {
            OptionsParameter param = OptionsManager.getInstance().getParameter(ConfigServiceCertificateStore.WS_CERT_RESOLVER_MAX_CACHE_SIZE);
            this.maxItems = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)1000);
            param = OptionsManager.getInstance().getParameter(ConfigServiceCertificateStore.WS_CERT_RESOLVER_CACHE_TTL);
            this.subjectTTL = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)3600);
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public int getSubjectTTL() {
            return this.subjectTTL;
        }
    }
}

